/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.social.workspace;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.core.Events;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.social.workspace.adapters.SocialDocument;
import org.nuxeo.ecm.social.workspace.helper.SocialWorkspaceHelper;

@Name(value="socialDocumentVisibilityActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=10)
public class SocialDocumentVisibilityActions
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(SocialDocumentVisibilityActions.class);
    @In(create=true)
    protected transient NavigationContext navigationContext;

    public void makePublic() throws ClientException {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        this.makePublic(currentDocument);
    }

    public void makePublic(DocumentModel document) throws ClientException {
        SocialDocument socialDocument = SocialWorkspaceHelper.toSocialDocument((DocumentModel)document);
        socialDocument.makePublic();
        Events.instance().raiseEvent("documentChanged", new Object[]{document});
    }

    public void restrictToMembers() throws ClientException {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        this.restrictToMembers(currentDocument);
    }

    public void restrictToMembers(DocumentModel document) throws ClientException {
        SocialDocument socialDocument = SocialWorkspaceHelper.toSocialDocument((DocumentModel)document);
        socialDocument.restrictToMembers();
        Events.instance().raiseEvent("documentChanged", new Object[]{document});
    }

    public boolean isPublic() throws ClientException {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        return this.isPublic(currentDocument);
    }

    public boolean isPublic(DocumentModel document) throws ClientException {
        SocialDocument socialDocument = SocialWorkspaceHelper.toSocialDocument((DocumentModel)document);
        return socialDocument.isPublic();
    }

    public boolean isRestricted() throws ClientException {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        return this.isRestricted(currentDocument);
    }

    public boolean isRestricted(DocumentModel document) throws ClientException {
        SocialDocument socialDocument = SocialWorkspaceHelper.toSocialDocument((DocumentModel)document);
        return socialDocument.isRestrictedToMembers();
    }
}

