/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.wall;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.nuxeo.ecm.activity.ActivitiesList;
import org.nuxeo.ecm.activity.ActivitiesListImpl;
import org.nuxeo.ecm.activity.Activity;
import org.nuxeo.ecm.activity.ActivityHelper;
import org.nuxeo.ecm.activity.ActivityReply;
import org.nuxeo.ecm.activity.ActivityStream;
import org.nuxeo.ecm.activity.ActivityStreamFilter;
import org.nuxeo.ecm.activity.ActivityStreamService;
import org.nuxeo.ecm.activity.ActivityStreamServiceImpl;
import org.nuxeo.ecm.core.api.DocumentModel;

public class WallActivityStreamFilter
implements ActivityStreamFilter {
    public static final String ID = "WallActivityStreamFilter";
    public static final String DEFAULT_WALL_ACTIVITY_STREAM_NAME = "defaultWallActivityStream";
    public static final String CONTEXT_DOCUMENT_PARAMETER = "contextDocumentParameter";
    public static final String ACTIVITY_STREAM_PARAMETER = "activityStreamParameter";

    public String getId() {
        return ID;
    }

    public boolean isInterestedIn(Activity activity) {
        return false;
    }

    public void handleNewActivity(ActivityStreamService activityStreamService, Activity activity) {
    }

    @Deprecated
    public void handleRemovedActivities(ActivityStreamService activityStreamService, Collection<Serializable> activityIds) {
    }

    public void handleRemovedActivities(ActivityStreamService activityStreamService, ActivitiesList activities) {
    }

    public void handleRemovedActivityReply(ActivityStreamService activityStreamService, Activity activity, ActivityReply activityReply) {
    }

    public ActivitiesList query(ActivityStreamService activityStreamService, Map<String, Serializable> parameters, long offset, long limit) {
        DocumentModel doc = (DocumentModel)parameters.get(CONTEXT_DOCUMENT_PARAMETER);
        if (doc == null) {
            throw new IllegalArgumentException("contextDocumentParameter is required");
        }
        String docActivityObject = ActivityHelper.createDocumentActivityObject((DocumentModel)doc);
        String activityStreamName = (String)((Object)parameters.get(ACTIVITY_STREAM_PARAMETER));
        if (activityStreamName == null) {
            activityStreamName = DEFAULT_WALL_ACTIVITY_STREAM_NAME;
        }
        ActivityStream wallActivityStream = activityStreamService.getActivityStream(activityStreamName);
        List verbs = wallActivityStream.getVerbs();
        EntityManager em = ((ActivityStreamServiceImpl)activityStreamService).getEntityManager();
        Query query = em.createQuery("select activity from Activity activity where activity.context = :context and activity.verb in (:verbs) and activity.actor like :actor order by activity.lastUpdatedDate desc");
        query.setParameter("context", (Object)docActivityObject);
        query.setParameter("verbs", (Object)verbs);
        query.setParameter("actor", (Object)"user:%");
        if (limit > 0L) {
            query.setMaxResults((int)limit);
            if (offset > 0L) {
                query.setFirstResult((int)offset);
            }
        }
        return new ActivitiesListImpl((Collection)query.getResultList());
    }
}

