/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.datasource;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.apache.commons.dbcp.managed.DataSourceXAConnectionFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PatchedDataSourceXAConnectionFactory
extends DataSourceXAConnectionFactory {
    private static final Log log = LogFactory.getLog(PatchedDataSourceXAConnectionFactory.class);

    public PatchedDataSourceXAConnectionFactory(TransactionManager transactionManager, XADataSource xaDataSource, String username, String password) {
        super(transactionManager, xaDataSource, username, password);
    }

    public Connection createConnection() throws SQLException {
        XAConnection xaConnection = this.username == null ? this.xaDataSource.getXAConnection() : this.xaDataSource.getXAConnection(this.username, this.password);
        Connection connection = xaConnection.getConnection();
        XAResource xaResource = xaConnection.getXAResource();
        this.transactionRegistry.registerConnection(connection, xaResource);
        xaConnection.addConnectionEventListener(new ConnectionEventListener(){

            @Override
            public void connectionClosed(ConnectionEvent event) {
                PooledConnection pc = (PooledConnection)event.getSource();
                pc.removeConnectionEventListener(this);
                try {
                    pc.close();
                }
                catch (SQLException e) {
                    log.error((Object)"Failed to close XAConnection", (Throwable)e);
                }
            }

            @Override
            public void connectionErrorOccurred(ConnectionEvent event) {
                this.connectionClosed(event);
            }
        });
        return connection;
    }
}

