/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.social.workspace.helper;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.activity.ActivityHelper;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.social.relationship.RelationshipKind;
import org.nuxeo.ecm.social.workspace.adapters.SocialDocument;
import org.nuxeo.ecm.social.workspace.adapters.SocialWorkspace;

public class SocialWorkspaceHelper {
    private static final Log log = LogFactory.getLog(SocialWorkspaceHelper.class);
    private static final String KIND_GROUP = "socialworkspace";
    private static final String ADMINISTRATORS_LABEL_PREFIX = "Administrators of ";
    private static final String MEMBERS_LABEL_PREFIX = "Members of ";

    private SocialWorkspaceHelper() {
    }

    public static String getSocialWorkspaceAdministratorsGroupName(String activityObject) {
        return activityObject + "_" + "administrators";
    }

    public static String getSocialWorkspaceAdministratorsGroupName(DocumentModel doc) {
        return ActivityHelper.createDocumentActivityObject((DocumentModel)doc) + "_" + "administrators";
    }

    public static String getSocialWorkspaceMembersGroupName(String activityObject) {
        return activityObject + "_" + "members";
    }

    public static String getSocialWorkspaceMembersGroupName(DocumentModel doc) {
        return ActivityHelper.createDocumentActivityObject((DocumentModel)doc) + "_" + "members";
    }

    public static String getSocialWorkspaceAdministratorsGroupLabel(String docTitle) {
        return ADMINISTRATORS_LABEL_PREFIX + docTitle;
    }

    public static String getSocialWorkspaceMembersGroupLabel(String docTitle) {
        return MEMBERS_LABEL_PREFIX + docTitle;
    }

    public static boolean isValidSocialWorkspaceGroupName(String groupName) {
        return !StringUtils.isBlank((String)groupName) && (groupName.endsWith(SocialWorkspaceHelper.getSocialWorkspaceAdministratorsGroupName("")) || groupName.endsWith(SocialWorkspaceHelper.getSocialWorkspaceMembersGroupName("")));
    }

    public static RelationshipKind buildRelationKindFromGroupName(String groupName) {
        String name = StringUtils.split((String)groupName, (String)"_")[1];
        if ("members".equals(name)) {
            return SocialWorkspaceHelper.buildRelationMemberKind();
        }
        if ("administrators".equals(name)) {
            return SocialWorkspaceHelper.buildRelationAdministratorKind();
        }
        log.warn((Object)("Trying to instantiate RelationshipKind from an unknown group: " + groupName));
        return null;
    }

    public static String getRelationDocActivityObjectFromGroupName(String groupName) {
        return StringUtils.split((String)groupName, (String)"_")[0];
    }

    public static RelationshipKind buildRelationMemberKind() {
        return RelationshipKind.newInstance((String)KIND_GROUP, (String)"members");
    }

    public static RelationshipKind buildRelationAdministratorKind() {
        return RelationshipKind.newInstance((String)KIND_GROUP, (String)"administrators");
    }

    public static RelationshipKind buildRelationKind() {
        return RelationshipKind.fromGroup((String)KIND_GROUP);
    }

    public static boolean isSocialWorkspaceContainer(DocumentModel doc) {
        return doc != null && doc.getType().equals("SocialDomain");
    }

    public static boolean isSocialWorkspace(DocumentModel doc) {
        return doc != null && doc.hasFacet("SocialWorkspace");
    }

    public static boolean isSocialDocument(DocumentModel doc) {
        return doc != null && !doc.isProxy() && !doc.isVersion() && doc.hasFacet("SocialDocument");
    }

    public static SocialWorkspace toSocialWorkspace(DocumentModel doc) {
        return (SocialWorkspace)doc.getAdapter(SocialWorkspace.class);
    }

    public static SocialDocument toSocialDocument(DocumentModel doc) {
        return (SocialDocument)doc.getAdapter(SocialDocument.class);
    }

    public static String getPrivateSectionPath(DocumentModel socialWorkspace) {
        if (socialWorkspace == null) {
            throw new IllegalArgumentException("Given social workspace is null, can't return the private section");
        }
        return socialWorkspace.getPathAsString() + "/" + "private-section/";
    }

    public static String getPublicSectionPath(DocumentModel socialWorkspace) {
        if (socialWorkspace == null) {
            throw new IllegalArgumentException("Given social workspace is null, can't return the private section");
        }
        return socialWorkspace.getPathAsString() + "/" + "public-section/";
    }

    public static String getNewsItemsRootPath(DocumentModel socialWorkspace) {
        if (socialWorkspace == null) {
            throw new IllegalArgumentException("Given social workspace is null, can't return the private section");
        }
        return socialWorkspace.getPathAsString() + "/" + "news-root/";
    }
}

