/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.social.workspace.listeners;

import java.io.Serializable;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.picture.api.ImageInfo;
import org.nuxeo.ecm.platform.picture.api.ImagingService;
import org.nuxeo.runtime.api.Framework;

public class ResizeArticlePictureListener
implements EventListener {
    private static final int RESIZED_IMAGE_WIDTH = 300;
    private static final int RESIZED_IMAGE_HEIGHT = 200;

    public void handleEvent(Event event) throws ClientException {
        ImagingService service;
        if (!event.getName().equals("aboutToCreate") && !event.getName().equals("beforeDocumentModification")) {
            return;
        }
        if (!(event.getContext() instanceof DocumentEventContext)) {
            return;
        }
        DocumentEventContext ctx = (DocumentEventContext)event.getContext();
        DocumentModel doc = ctx.getSourceDocument();
        if (!"Article".equals(doc.getType())) {
            return;
        }
        Blob image = (Blob)doc.getPropertyValue("contentpict:picture");
        if (image == null) {
            return;
        }
        try {
            service = (ImagingService)Framework.getService(ImagingService.class);
        }
        catch (Exception e) {
            throw new ClientException("Failed to get ImagingService", (Throwable)e);
        }
        ImageInfo info = service.getImageInfo(image);
        int width = info.getWidth();
        int height = info.getHeight();
        float wScale = 300.0f / (float)width;
        float hscale = 200.0f / (float)height;
        float scale = Math.min(wScale, hscale);
        if (scale < 1.0f) {
            image = service.resize(image, "jpg", (int)((float)width * scale), (int)((float)height * scale), info.getDepth());
            image.setMimeType("image/jpeg");
            doc.setPropertyValue("contentpict:picture", (Serializable)image);
        }
    }
}

