/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.social.mini.message;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.nuxeo.ecm.activity.AbstractActivityPageProvider;
import org.nuxeo.ecm.activity.ActivityHelper;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.social.relationship.RelationshipKind;

public abstract class AbstractMiniMessagePageProvider<T>
extends AbstractActivityPageProvider<T> {
    public static final String LOCALE_PROPERTY = "locale";
    public static final String ACTOR_PROPERTY = "actor";
    public static final String RELATIONSHIP_KIND_PROPERTY = "relationshipKind";
    public static final String STREAM_TYPE_PROPERTY = "streamType";
    public static final String FOR_ACTOR_STREAM_TYPE = "forActor";
    public static final String FROM_ACTOR_STREAM_TYPE = "fromActor";
    protected List<T> pageMiniMessages;

    protected Locale getLocale() {
        Map props = this.getProperties();
        Locale locale = (Locale)props.get(LOCALE_PROPERTY);
        if (locale == null) {
            throw new ClientRuntimeException("Cannot find locale property.");
        }
        return locale;
    }

    protected String getActor() {
        Map props = this.getProperties();
        String actor = (String)props.get(ACTOR_PROPERTY);
        if (actor == null) {
            throw new ClientRuntimeException("Cannot find actor property.");
        }
        return ActivityHelper.createUserActivityObject((String)actor);
    }

    protected String getStreamType() {
        Map props = this.getProperties();
        String streamType = (String)props.get(STREAM_TYPE_PROPERTY);
        if (streamType == null) {
            streamType = FOR_ACTOR_STREAM_TYPE;
        }
        return streamType;
    }

    protected RelationshipKind getRelationshipKind() {
        Map props = this.getProperties();
        String relationshipKind = (String)props.get(RELATIONSHIP_KIND_PROPERTY);
        if (relationshipKind == null) {
            throw new ClientRuntimeException("Cannot find relationshipKind property.");
        }
        return RelationshipKind.fromString((String)relationshipKind);
    }

    public boolean isSortable() {
        return false;
    }

    protected void pageChanged() {
        this.pageMiniMessages = null;
        super.pageChanged();
    }

    public void refresh() {
        this.pageMiniMessages = null;
        super.refresh();
    }
}

