/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.social.workspace.listeners;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.platform.task.Task;
import org.nuxeo.ecm.platform.task.TaskService;
import org.nuxeo.runtime.api.Framework;

public class CheckSocialWorkspaceValidationTasks
implements EventListener {
    protected TaskService taskService;
    protected AutomationService automationService;
    private static final Log log = LogFactory.getLog(CheckSocialWorkspaceValidationTasks.class);
    public static final String QUERY_SELECT_NOT_VALIDATED_SOCIAL_WORKSPACES = "SELECT * FROM SocialWorkspace WHERE ecm:isCheckedInVersion = 0 AND ecm:currentLifeCycleState = 'project'";

    public void handleEvent(Event event) throws ClientException {
        if (!"checkExpiredTasksSignal".equals(event.getName())) {
            return;
        }
        try {
            UnrestrictedSocialWorkspaceValidationTasksChecker checker = new UnrestrictedSocialWorkspaceValidationTasksChecker();
            checker.runUnrestricted();
        }
        catch (Exception e) {
            log.debug((Object)"failed to open session", (Throwable)e);
        }
    }

    private void checkTasksFor(DocumentModel doc, CoreSession coreSession) throws ClientException {
        List taskInstances = this.getTaskService().getTaskInstances(doc, (NuxeoPrincipal)null, coreSession);
        ArrayList<Task> canceledTasks = new ArrayList<Task>();
        for (Task task : taskInstances) {
            if (!"validateSocialWorkspace".equals(task.getName()) || !CheckSocialWorkspaceValidationTasks.isExpired(task)) continue;
            OperationContext ctx = new OperationContext(doc.getCoreSession());
            ctx.setInput((Object)doc);
            try {
                task.cancel(coreSession);
                this.getAutomationService().run(ctx, "SocialWorkspaceNotValidatedChain");
                task.cancel(coreSession);
                canceledTasks.add(task);
            }
            catch (Exception e) {
                log.warn((Object)("failed to invalidate social workspace" + doc.getTitle()), (Throwable)e);
            }
        }
        if (!canceledTasks.isEmpty()) {
            DocumentModel[] docToSave = new DocumentModel[canceledTasks.size()];
            canceledTasks.toArray(docToSave);
            coreSession.saveDocuments(docToSave);
        }
    }

    private static boolean isExpired(Task task) throws ClientException {
        Date date = task.getDueDate();
        return date != null && date.before(new Date());
    }

    private AutomationService getAutomationService() throws Exception {
        if (this.automationService == null) {
            this.automationService = (AutomationService)Framework.getService(AutomationService.class);
        }
        return this.automationService;
    }

    protected TaskService getTaskService() {
        if (this.taskService == null) {
            try {
                this.taskService = (TaskService)Framework.getService(TaskService.class);
            }
            catch (Exception e) {
                log.warn((Object)"failed to get JbpmService service", (Throwable)e);
            }
        }
        return this.taskService;
    }

    protected class UnrestrictedSocialWorkspaceValidationTasksChecker
    extends UnrestrictedSessionRunner {
        protected UnrestrictedSocialWorkspaceValidationTasksChecker() throws Exception {
            super(((RepositoryManager)Framework.getService(RepositoryManager.class)).getDefaultRepositoryName());
        }

        public void run() throws ClientException {
            DocumentModelList list = this.session.query(CheckSocialWorkspaceValidationTasks.QUERY_SELECT_NOT_VALIDATED_SOCIAL_WORKSPACES);
            for (DocumentModel doc : list) {
                CheckSocialWorkspaceValidationTasks.this.checkTasksFor(doc, this.session);
            }
        }
    }
}

