/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.social.relationship;

import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class RelationshipKind
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SEPARATOR = ":";
    protected final String group;
    protected final String name;

    protected RelationshipKind(String group, String name) {
        this.group = StringUtils.isBlank((String)group) ? "" : group;
        this.name = StringUtils.isBlank((String)name) ? "" : name;
    }

    public static RelationshipKind newInstance(String group, String kindName) {
        return new RelationshipKind(group, kindName);
    }

    public static RelationshipKind fromString(String value) {
        int pos = value.indexOf(SEPARATOR);
        if (pos >= 0) {
            String group = value.substring(0, pos);
            String name = value.substring(pos + 1, value.length());
            return new RelationshipKind(group, name);
        }
        return null;
    }

    public static RelationshipKind fromGroup(String group) {
        return RelationshipKind.newInstance(group, "");
    }

    public static RelationshipKind fromName(String name) {
        return RelationshipKind.newInstance("", name);
    }

    public boolean isEmpty() {
        return StringUtils.isEmpty((String)this.group) && StringUtils.isEmpty((String)this.name);
    }

    public String getGroup() {
        return this.group;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.group + SEPARATOR + this.name;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }
}

