/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.social.workspace.gadgets;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.nuxeo.ecm.activity.AbstractActivityPageProvider;
import org.nuxeo.ecm.activity.ActivityHelper;
import org.nuxeo.ecm.activity.ActivityMessage;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.impl.blob.InputStreamBlob;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.ecm.social.mini.message.MiniMessageHelper;
import org.nuxeo.ecm.social.workspace.adapters.SocialWorkspace;
import org.nuxeo.ecm.social.workspace.service.SocialWorkspaceService;

@Operation(id="Services.GetSocialWorkspaceMiniMessages", category="Services", label="Get social workspace mini messages", description="Get social workspace mini messages.")
public class GetSocialWorkspaceMiniMessages {
    public static final String ID = "Services.GetSocialWorkspaceMiniMessages";
    public static final String SOCIAL_WORKSPACE_MEMBER_KIND = "socialworkspace:member";
    public static final String PROVIDER_NAME = "social_workspace_mini_messages";
    public static final String ACTIVITIES_PROVIDER_NAME = "social_workspace_mini_message_activities";
    @Context
    protected CoreSession session;
    @Context
    protected PageProviderService pageProviderService;
    @Context
    protected SocialWorkspaceService socialWorkspaceService;
    @Param(name="contextPath", required=true)
    protected String contextPath;
    @Param(name="relationshipKind", required=false)
    protected String relationshipKind;
    @Param(name="language", required=false)
    protected String language;
    @Param(name="offset", required=false)
    protected Integer offset;
    @Param(name="limit", required=false)
    protected Integer limit;
    @Param(name="asActivities", required=false)
    protected Boolean asActivities = false;

    @OperationMethod
    public Blob run() throws Exception {
        Long targetOffset = 0L;
        if (this.offset != null) {
            targetOffset = this.offset.longValue();
        }
        Long targetLimit = null;
        if (this.limit != null) {
            targetLimit = this.limit.longValue();
        }
        String kind = StringUtils.isBlank((String)this.relationshipKind) ? SOCIAL_WORKSPACE_MEMBER_KIND : this.relationshipKind;
        Locale locale = this.language != null && !this.language.isEmpty() ? new Locale(this.language) : Locale.ENGLISH;
        SocialWorkspace socialWorkspace = this.socialWorkspaceService.getDetachedSocialWorkspace(this.session, (DocumentRef)new PathRef(this.contextPath));
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("locale", locale);
        props.put("socialWorkspaceId", socialWorkspace.getId());
        props.put("repositoryName", socialWorkspace.getDocument().getRepositoryName());
        props.put("relationshipKind", kind);
        if (this.asActivities.booleanValue()) {
            PageProvider pageProvider = this.pageProviderService.getPageProvider(ACTIVITIES_PROVIDER_NAME, null, targetLimit, Long.valueOf(0L), props, new Object[0]);
            pageProvider.setCurrentPageOffset(targetOffset.longValue());
            ArrayList<Map> miniMessages = new ArrayList<Map>();
            for (ActivityMessage activityMessage : pageProvider.getCurrentPage()) {
                Map o = activityMessage.toMap(this.session, locale);
                String actorUsername = ActivityHelper.getUsername((String)activityMessage.getActor());
                o.put("allowDeletion", this.session.getPrincipal().getName().equals(actorUsername));
                miniMessages.add(o);
            }
            HashMap<String, Serializable> m = new HashMap<String, Serializable>();
            m.put("offset", Long.valueOf(((AbstractActivityPageProvider)pageProvider).getNextOffset()));
            m.put("limit", Long.valueOf(pageProvider.getCurrentPageSize()));
            m.put("miniMessages", miniMessages);
            ObjectMapper mapper = new ObjectMapper();
            StringWriter writer = new StringWriter();
            mapper.writeValue((Writer)writer, m);
            String json = writer.toString();
            return new InputStreamBlob((InputStream)new ByteArrayInputStream(json.getBytes("UTF-8")), "application/json");
        }
        PageProvider pageProvider = this.pageProviderService.getPageProvider(PROVIDER_NAME, null, targetLimit, Long.valueOf(0L), props, new Object[0]);
        pageProvider.setCurrentPageOffset(targetOffset.longValue());
        String json = MiniMessageHelper.toJSON((PageProvider)pageProvider, (Locale)locale, (CoreSession)this.session);
        return new InputStreamBlob((InputStream)new ByteArrayInputStream(json.getBytes("UTF-8")), "application/json");
    }
}

