/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.social.workspace.listeners;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.collections.ScopeType;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.social.workspace.adapters.SocialWorkspace;
import org.nuxeo.ecm.social.workspace.helper.SocialWorkspaceHelper;
import org.nuxeo.ecm.social.workspace.service.SocialWorkspaceService;
import org.nuxeo.runtime.api.Framework;

public class SocialWorkspaceListener
implements EventListener {
    private static final Log log = LogFactory.getLog(SocialWorkspaceListener.class);
    public static final String DO_NOT_PROCESS = "doNotProcess";

    public void handleEvent(Event event) throws ClientException {
        if (!(event.getContext() instanceof DocumentEventContext)) {
            return;
        }
        DocumentEventContext ctx = (DocumentEventContext)event.getContext();
        if (ctx.hasProperty(DO_NOT_PROCESS)) {
            return;
        }
        DocumentModel doc = ctx.getSourceDocument();
        if (!SocialWorkspaceHelper.isSocialWorkspace(doc)) {
            return;
        }
        doc.putContextData(ScopeType.REQUEST, DO_NOT_PROCESS, (Serializable)Boolean.valueOf(true));
        SocialWorkspace socialWorkspace = SocialWorkspaceHelper.toSocialWorkspace(doc);
        if ("documentCreated".equals(event.getName())) {
            SocialWorkspaceListener.handleSocialWorkspaceCreation(socialWorkspace, (EventContext)ctx);
        } else if ("documentModified".equals(event.getName())) {
            SocialWorkspaceListener.updateSocialWorkspaceVisibility(socialWorkspace);
        } else if ("documentRemoved".equals(event.getName())) {
            SocialWorkspaceListener.handleSocialWorkspaceDeletion(socialWorkspace);
        }
        doc.getContextData().remove((Object)ScopeType.REQUEST.getScopedKey(DO_NOT_PROCESS));
    }

    private static void handleSocialWorkspaceCreation(SocialWorkspace socialWorkspace, EventContext ctx) {
        SocialWorkspaceListener.getSocialWorkspaceService().handleSocialWorkspaceCreation(socialWorkspace, ctx.getPrincipal());
    }

    private static void updateSocialWorkspaceVisibility(SocialWorkspace socialWorkspace) {
        if (socialWorkspace.isPublic()) {
            socialWorkspace.makePublic();
        } else if (socialWorkspace.isPrivate()) {
            socialWorkspace.makePrivate();
        }
    }

    private static void handleSocialWorkspaceDeletion(SocialWorkspace socialWorkspace) {
        SocialWorkspaceListener.getSocialWorkspaceService().handleSocialWorkspaceDeletion(socialWorkspace);
    }

    private static SocialWorkspaceService getSocialWorkspaceService() {
        try {
            return (SocialWorkspaceService)Framework.getService(SocialWorkspaceService.class);
        }
        catch (Exception e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }
}

