/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.browser;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.Principal;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.impl.Base64;
import org.apache.chemistry.opencmis.commons.impl.IOUtils;
import org.apache.chemistry.opencmis.commons.impl.TypeCache;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AccessControlEntryImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AccessControlListImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AccessControlPrincipalDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ContentStreamImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertiesImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyBooleanImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyDateTimeImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyDecimalImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyHtmlImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyIdImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyIntegerImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyStringImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyUriImpl;
import org.apache.chemistry.opencmis.commons.impl.json.JSONObject;
import org.apache.chemistry.opencmis.commons.impl.json.JSONStreamAware;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.server.impl.browser.ControlParser;
import org.apache.chemistry.opencmis.server.impl.browser.POSTHttpServletRequestWrapper;
import org.apache.chemistry.opencmis.server.shared.AbstractServiceCall;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBrowserServiceCall
extends AbstractServiceCall {
    public static final String JSON_MIME_TYPE = "application/json";
    public static final String HTML_MIME_TYPE = "text/html";
    public static final String ROOT_PATH_FRAGMENT = "root";
    public static final String REPOSITORY_PLACEHOLDER = "{repositoryId}";

    public UrlBuilder compileBaseUrl(HttpServletRequest request, String repositoryId) {
        String baseUrl = (String)request.getAttribute("org.apache.chemistry.opencmis.baseurl");
        if (baseUrl != null) {
            int repIdPos = baseUrl.indexOf(REPOSITORY_PLACEHOLDER);
            if (repIdPos < 0) {
                return new UrlBuilder(baseUrl);
            }
            return new UrlBuilder(baseUrl.substring(0, repIdPos) + repositoryId + baseUrl.substring(repIdPos + REPOSITORY_PLACEHOLDER.length()));
        }
        UrlBuilder url = new UrlBuilder(request.getScheme(), request.getServerName(), request.getServerPort(), null);
        url.addPath(request.getContextPath());
        url.addPath(request.getServletPath());
        url.addPathSegment(repositoryId);
        return url;
    }

    public UrlBuilder compileRepositoryUrl(HttpServletRequest request, String repositoryId) {
        return this.compileBaseUrl(request, repositoryId);
    }

    public UrlBuilder compileRootUrl(HttpServletRequest request, String repositoryId) {
        return this.compileRepositoryUrl(request, repositoryId).addPathSegment(ROOT_PATH_FRAGMENT);
    }

    public String compileObjectLocationUrl(HttpServletRequest request, String repositoryId, String objectId) {
        return this.compileRootUrl(request, repositoryId).addParameter("objectId", (Object)objectId).toString();
    }

    public String compileTypeLocationUrl(HttpServletRequest request, String repositoryId, String typeId) {
        return this.compileRepositoryUrl(request, repositoryId).addParameter("typeId", (Object)typeId).toString();
    }

    public void writeJSON(JSONStreamAware json, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String token = this.getStringParameter(request, "token");
        if (token != null && "POST".equals(request.getMethod())) {
            response.setContentType(HTML_MIME_TYPE);
            response.setContentLength(0);
        } else {
            response.setContentType(JSON_MIME_TYPE);
            response.setCharacterEncoding("UTF-8");
            PrintWriter pw = response.getWriter();
            String callback = this.getStringParameter(request, "callback");
            if (callback != null) {
                if (!callback.matches("[A-Za-z0-9._\\[\\]]*")) {
                    throw new CmisInvalidArgumentException("Invalid callback name!");
                }
                pw.print(callback + "(");
            }
            json.writeJSONString((Writer)pw);
            if (callback != null) {
                pw.print(");");
            }
            pw.flush();
        }
    }

    public void writeEmpty(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentLength(0);
        response.setContentType(HTML_MIME_TYPE);
        response.getWriter().flush();
    }

    public ObjectData getSimpleObject(CmisService service, String repositoryId, String objectId) {
        return service.getObject(repositoryId, objectId, null, Boolean.valueOf(false), IncludeRelationships.NONE, "cmis:none", Boolean.valueOf(false), Boolean.valueOf(false), null);
    }

    public void setStatus(HttpServletRequest request, HttpServletResponse response, int statusCode) {
        if (this.getBooleanParameter(request, "suppressResponseCodes", false)) {
            statusCode = 200;
        }
        response.setStatus(statusCode);
    }

    public String getCookieName(String token) {
        if (token == null || token.length() == 0) {
            return "cmis%";
        }
        return "cmis_" + Base64.encodeBytes((byte[])IOUtils.toUTF8Bytes((String)token)).replace('=', '%');
    }

    public void setCookie(HttpServletRequest request, HttpServletResponse response, String repositoryId, String token, String value) {
        this.setCookie(request, response, repositoryId, token, value, 3600);
    }

    public void deleteCookie(HttpServletRequest request, HttpServletResponse response, String repositoryId, String token) {
        this.setCookie(request, response, repositoryId, token, "", 0);
    }

    public void setCookie(HttpServletRequest request, HttpServletResponse response, String repositoryId, String token, String value, int expiry) {
        if (token != null && token.length() > 0) {
            String cookieValue = IOUtils.encodeURL((String)value);
            Cookie transactionCookie = new Cookie(this.getCookieName(token), cookieValue);
            transactionCookie.setMaxAge(expiry);
            transactionCookie.setPath(request.getContextPath() + request.getServletPath() + "/" + repositoryId);
            response.addCookie(transactionCookie);
        }
    }

    public String createCookieValue(int code, String objectId, String ex, String message) {
        JSONObject result = new JSONObject();
        result.put("code", (Object)code);
        result.put("objectId", (Object)(objectId == null ? "" : objectId));
        result.put("exception", (Object)(ex == null ? "" : ex));
        result.put("message", (Object)(message == null ? "" : message));
        return result.toJSONString();
    }

    public Properties createNewProperties(ControlParser controlParser, TypeCache typeCache) {
        TypeDefinition typeDef;
        Map<String, List<String>> properties = controlParser.getProperties();
        if (properties == null) {
            return null;
        }
        List<String> objectTypeIdsValues = properties.get("cmis:objectTypeId");
        if (objectTypeIdsValues != null && !objectTypeIdsValues.isEmpty() && (typeDef = typeCache.getTypeDefinition(objectTypeIdsValues.get(0))) == null) {
            throw new CmisInvalidArgumentException("Invalid type: " + objectTypeIdsValues.get(0));
        }
        List<String> secondaryObjectTypeIdsValues = properties.get("cmis:secondaryObjectTypeIds");
        if (secondaryObjectTypeIdsValues != null && !secondaryObjectTypeIdsValues.isEmpty()) {
            for (String secTypeId : secondaryObjectTypeIdsValues) {
                TypeDefinition typeDef2 = typeCache.getTypeDefinition(secTypeId);
                if (typeDef2 != null) continue;
                throw new CmisInvalidArgumentException("Invalid type: " + secTypeId);
            }
        }
        PropertiesImpl result = new PropertiesImpl();
        for (Map.Entry<String, List<String>> property : properties.entrySet()) {
            PropertyDefinition propDef = typeCache.getPropertyDefinition(property.getKey());
            if (propDef == null) {
                throw new CmisInvalidArgumentException(property.getKey() + " is unknown!");
            }
            result.addProperty(this.createPropertyData(propDef, property.getValue()));
        }
        return result;
    }

    public Properties createUpdateProperties(ControlParser controlParser, String typeId, List<String> secondaryTypeIds, List<String> objectIds, TypeCache typeCache) {
        TypeDefinition typeDef;
        TypeDefinition typeDef2;
        Map<String, List<String>> properties = controlParser.getProperties();
        if (properties == null) {
            return null;
        }
        if (typeId != null && (typeDef2 = typeCache.getTypeDefinition(typeId)) == null) {
            throw new CmisInvalidArgumentException("Invalid type: " + typeId);
        }
        List<String> secondaryObjectTypeIdsValues = properties.get("cmis:secondaryObjectTypeIds");
        if (secondaryObjectTypeIdsValues != null && !secondaryObjectTypeIdsValues.isEmpty()) {
            for (String secTypeId : secondaryObjectTypeIdsValues) {
                typeDef = typeCache.getTypeDefinition(secTypeId);
                if (typeDef != null) continue;
                throw new CmisInvalidArgumentException("Invalid type: " + secTypeId);
            }
        }
        if (secondaryTypeIds != null) {
            for (String secTypeId : secondaryTypeIds) {
                typeDef = typeCache.getTypeDefinition(secTypeId);
                if (typeDef != null) continue;
                throw new CmisInvalidArgumentException("Invalid secondary type: " + secTypeId);
            }
        }
        PropertiesImpl result = new PropertiesImpl();
        for (Map.Entry<String, List<String>> property : properties.entrySet()) {
            PropertyDefinition propDef = typeCache.getPropertyDefinition(property.getKey());
            if (propDef == null && objectIds != null) {
                for (String objectId : objectIds) {
                    typeCache.getTypeDefinitionForObject(objectId);
                    propDef = typeCache.getPropertyDefinition(property.getKey());
                    if (propDef == null) continue;
                    break;
                }
            }
            if (propDef == null) {
                throw new CmisInvalidArgumentException(property.getKey() + " is unknown!");
            }
            result.addProperty(this.createPropertyData(propDef, property.getValue()));
        }
        return result;
    }

    private PropertyData<?> createPropertyData(PropertyDefinition<?> propDef, Object value) {
        ArrayList<String> strValues;
        if (value == null) {
            strValues = Collections.emptyList();
        } else if (value instanceof String) {
            strValues = new ArrayList<String>();
            strValues.add((String)value);
        } else {
            strValues = (ArrayList<String>)value;
        }
        PropertyStringImpl propertyData = null;
        switch (propDef.getPropertyType()) {
            case STRING: {
                propertyData = new PropertyStringImpl(propDef.getId(), strValues);
                break;
            }
            case ID: {
                propertyData = new PropertyIdImpl(propDef.getId(), strValues);
                break;
            }
            case BOOLEAN: {
                ArrayList<Boolean> boolValues = new ArrayList<Boolean>(strValues.size());
                for (String s : strValues) {
                    boolValues.add(Boolean.valueOf(s));
                }
                propertyData = new PropertyBooleanImpl(propDef.getId(), boolValues);
                break;
            }
            case INTEGER: {
                ArrayList<BigInteger> intValues = new ArrayList<BigInteger>(strValues.size());
                try {
                    for (String s : strValues) {
                        intValues.add(new BigInteger(s));
                    }
                }
                catch (NumberFormatException e) {
                    throw new CmisInvalidArgumentException(propDef.getId() + " value is not an integer value!", (Throwable)e);
                }
                propertyData = new PropertyIntegerImpl(propDef.getId(), intValues);
                break;
            }
            case DECIMAL: {
                ArrayList<BigDecimal> decValues = new ArrayList<BigDecimal>(strValues.size());
                try {
                    for (String s : strValues) {
                        decValues.add(new BigDecimal(s));
                    }
                }
                catch (NumberFormatException e) {
                    throw new CmisInvalidArgumentException(propDef.getId() + " value is not an integer value!", (Throwable)e);
                }
                propertyData = new PropertyDecimalImpl(propDef.getId(), decValues);
                break;
            }
            case DATETIME: {
                ArrayList<GregorianCalendar> calValues = new ArrayList<GregorianCalendar>(strValues.size());
                try {
                    for (String s : strValues) {
                        GregorianCalendar cal = new GregorianCalendar();
                        cal.setTimeInMillis(Long.parseLong(s));
                        calValues.add(cal);
                    }
                }
                catch (NumberFormatException e) {
                    throw new CmisInvalidArgumentException(propDef.getId() + " value is not an datetime value!", (Throwable)e);
                }
                propertyData = new PropertyDateTimeImpl(propDef.getId(), calValues);
                break;
            }
            case HTML: {
                propertyData = new PropertyHtmlImpl(propDef.getId(), strValues);
                break;
            }
            case URI: {
                propertyData = new PropertyUriImpl(propDef.getId(), strValues);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return propertyData;
    }

    public List<String> createPolicies(ControlParser controlParser) {
        return controlParser.getValues("policy");
    }

    public Acl createAddAcl(ControlParser controlParser) {
        List<String> principals = controlParser.getValues("addACEPrincipal");
        if (principals == null) {
            return null;
        }
        ArrayList<AccessControlEntryImpl> aces = new ArrayList<AccessControlEntryImpl>();
        int i = 0;
        for (String principalId : principals) {
            aces.add(new AccessControlEntryImpl((Principal)new AccessControlPrincipalDataImpl(principalId), controlParser.getValues("addACEPermission", i)));
            ++i;
        }
        return new AccessControlListImpl(aces);
    }

    public Acl createRemoveAcl(ControlParser controlParser) {
        List<String> principals = controlParser.getValues("removeACEPrincipal");
        if (principals == null) {
            return null;
        }
        ArrayList<AccessControlEntryImpl> aces = new ArrayList<AccessControlEntryImpl>();
        int i = 0;
        for (String principalId : principals) {
            aces.add(new AccessControlEntryImpl((Principal)new AccessControlPrincipalDataImpl(principalId), controlParser.getValues("removeACEPermission", i)));
            ++i;
        }
        return new AccessControlListImpl(aces);
    }

    public ContentStream createContentStream(HttpServletRequest request) {
        POSTHttpServletRequestWrapper post;
        ContentStreamImpl result = null;
        if (request instanceof POSTHttpServletRequestWrapper && (post = (POSTHttpServletRequestWrapper)request).getStream() != null) {
            result = new ContentStreamImpl(post.getFilename(), post.getSize(), post.getContentType(), post.getStream());
        }
        return result;
    }
}

