/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.support.wrapper;

import java.lang.reflect.Constructor;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.ClassLoaderUtil;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.server.support.wrapper.AbstractCmisServiceWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmisServiceWrapperManager {
    private static final Logger LOG = LoggerFactory.getLogger(CmisServiceWrapperManager.class);
    private static final String PARAMS_SERVICE_WRAPPER_PREFIX = "servicewrapper.";
    private WrapperDefinition outerMost = null;
    private WrapperDefinition innerMost = null;

    public void addOuterWrapper(Class<? extends AbstractCmisServiceWrapper> wrapperClass, Object ... params) {
        WrapperDefinition wd = new WrapperDefinition(wrapperClass, params);
        if (this.outerMost == null) {
            this.outerMost = wd;
            this.innerMost = wd;
        } else {
            this.outerMost.setOuterWrapper(wd);
            this.outerMost = wd;
        }
        LOG.debug("Added outer service wrapper: {}", (Object)wrapperClass.getName());
    }

    public void addInnerWrapper(Class<? extends AbstractCmisServiceWrapper> wrapperClass, Object ... params) {
        WrapperDefinition wd = new WrapperDefinition(wrapperClass, params);
        if (this.innerMost == null) {
            this.outerMost = wd;
            this.innerMost = wd;
        } else {
            this.innerMost.setInnerWrapper(wd);
            this.innerMost = wd;
        }
        LOG.debug("Added inner service wrapper: {}", (Object)wrapperClass.getName());
    }

    public void addWrappersFromServiceFactoryParameters(Map<String, String> parameters) {
        if (parameters == null) {
            return;
        }
        TreeMap<Integer, WrapperDefinition> wrappers = new TreeMap<Integer, WrapperDefinition>();
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            String key = entry.getKey().trim().toLowerCase(Locale.ENGLISH);
            if (!key.startsWith(PARAMS_SERVICE_WRAPPER_PREFIX) || entry.getKey() == null) continue;
            int index = 0;
            try {
                index = Integer.valueOf(key.substring(PARAMS_SERVICE_WRAPPER_PREFIX.length()));
            }
            catch (NumberFormatException e) {
                throw new CmisRuntimeException("Invalid service wrapper configuration: " + key, (Throwable)e);
            }
            String[] value = entry.getValue().trim().split(",");
            if (value.length <= 0) continue;
            Class wrapperClass = null;
            try {
                wrapperClass = ClassLoaderUtil.loadClass((String)value[0]);
            }
            catch (ClassNotFoundException e) {
                throw new CmisRuntimeException("Service wrapper class not found: " + value[0], (Throwable)e);
            }
            if (!AbstractCmisServiceWrapper.class.isAssignableFrom(wrapperClass)) {
                throw new CmisRuntimeException("Class is not a service wrapper: " + value[0]);
            }
            Object[] params = null;
            if (value.length > 1) {
                params = new Object[value.length - 1];
                System.arraycopy(value, 1, params, 0, params.length);
            }
            if (wrappers.containsKey(index)) {
                throw new CmisRuntimeException("More than one service wrapper at the same position: " + index);
            }
            LOG.trace("Found wrapper at index {}: {}{}", new Object[]{index, wrapperClass.getName(), params == null ? "" : params.toString()});
            wrappers.put(index, new WrapperDefinition(wrapperClass, params));
        }
        if (!wrappers.isEmpty()) {
            WrapperDefinition first = null;
            WrapperDefinition prev = null;
            for (WrapperDefinition def : wrappers.values()) {
                def.setOuterWrapper(prev);
                prev = def;
                if (first == null) {
                    first = def;
                }
                LOG.debug("Added service wrapper: {}", (Object)def.getWrapperClass().getName());
            }
            if (this.outerMost == null) {
                this.outerMost = first;
                this.innerMost = prev;
            } else {
                this.outerMost.setOuterWrapper(prev);
                this.outerMost = first;
            }
        }
    }

    public void removeOuterWrapper() {
        if (this.outerMost != null) {
            this.outerMost = this.outerMost.getInnerWrapper();
            if (this.outerMost == null) {
                this.innerMost = null;
            } else {
                this.outerMost.setOuterWrapper(null);
            }
        }
    }

    public void removeInnerWrapper() {
        if (this.innerMost != null) {
            this.innerMost = this.innerMost.getOuterWrapper();
            if (this.innerMost == null) {
                this.outerMost = null;
            } else {
                this.innerMost.setInnerWrapper(null);
            }
        }
    }

    public CmisService wrap(CmisService service) {
        CmisService result = service;
        for (WrapperDefinition def = this.innerMost; def != null; def = def.getOuterWrapper()) {
            result = def.createWrapperObject(result);
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (WrapperDefinition def = this.outerMost; def != null; def = def.getInnerWrapper()) {
            sb.append('[');
            sb.append(def.toString());
            sb.append(']');
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WrapperDefinition {
        private static final Class<?>[] CONSTRUCTOR_PARAMETERS = new Class[]{CmisService.class};
        private final Class<? extends AbstractCmisServiceWrapper> wrapperClass;
        private final Constructor<? extends AbstractCmisServiceWrapper> wrapperConstructor;
        private final Object[] params;
        private WrapperDefinition outer;
        private WrapperDefinition inner;

        public WrapperDefinition(Class<? extends AbstractCmisServiceWrapper> wrapperClass, Object ... params) {
            this.wrapperClass = wrapperClass;
            this.params = params;
            if (wrapperClass == null) {
                throw new CmisRuntimeException("Wrapper class must be set!");
            }
            try {
                this.wrapperConstructor = wrapperClass.getConstructor(CONSTRUCTOR_PARAMETERS);
            }
            catch (Exception e) {
                throw new CmisRuntimeException("Could not access constructor of service wrapper " + wrapperClass.getName() + ": " + e.toString(), (Throwable)e);
            }
        }

        public Class<? extends AbstractCmisServiceWrapper> getWrapperClass() {
            return this.wrapperClass;
        }

        public AbstractCmisServiceWrapper createWrapperObject(CmisService service) {
            try {
                AbstractCmisServiceWrapper wrapper = this.wrapperConstructor.newInstance(service);
                wrapper.initialize(this.params);
                return wrapper;
            }
            catch (Exception e) {
                throw new CmisRuntimeException("Could not instantiate service wrapper " + this.wrapperClass.getName() + ": " + e.toString(), (Throwable)e);
            }
        }

        public void setOuterWrapper(WrapperDefinition wrapper) {
            this.outer = wrapper;
            if (wrapper != null) {
                wrapper.inner = this;
            }
        }

        public WrapperDefinition getOuterWrapper() {
            return this.outer;
        }

        public void setInnerWrapper(WrapperDefinition wrapper) {
            this.inner = wrapper;
            if (wrapper != null) {
                wrapper.outer = this;
            }
        }

        public WrapperDefinition getInnerWrapper() {
            return this.inner;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.wrapperClass.getName());
            if (this.params != null) {
                for (int i = 0; i < this.params.length; ++i) {
                    sb.append(',');
                    sb.append(this.params[i]);
                }
            }
            return sb.toString();
        }
    }
}

