/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.shared;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.chemistry.opencmis.commons.impl.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class ExceptionHelper {
    public static final String STACK_TRACE_PROPERTY = "org.apache.chemistry.opencmis.stacktrace.disable";
    private static final boolean SEND_STACK_TRACE = System.getProperty("org.apache.chemistry.opencmis.stacktrace.disable") == null;

    private ExceptionHelper() {
    }

    public static String getStacktraceAsString(Throwable t) {
        if (!SEND_STACK_TRACE || t == null) {
            return null;
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        return sw.toString();
    }

    public static Node getStacktraceAsNode(Throwable t) {
        block3: {
            try {
                String st = ExceptionHelper.getStacktraceAsString(t);
                if (st != null) {
                    Document doc = XMLUtils.newDomDocument();
                    Element node = doc.createElementNS("http://chemistry.apache.org/opencmis/exception", "stacktrace");
                    doc.appendChild(node);
                    node.appendChild(doc.createTextNode(st));
                    return node;
                }
            }
            catch (Exception e) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
        return null;
    }
}

