/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.shared;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.chemistry.opencmis.commons.impl.IOUtils;

public final class HttpUtils {
    private HttpUtils() {
    }

    public static String getStringParameter(HttpServletRequest request, String name) {
        assert (request != null);
        if (name == null) {
            return null;
        }
        Map parameters = request.getParameterMap();
        for (Map.Entry parameter : parameters.entrySet()) {
            if (!name.equalsIgnoreCase((String)parameter.getKey())) continue;
            if (parameter.getValue() == null) {
                return null;
            }
            return ((String[])parameter.getValue())[0];
        }
        return null;
    }

    public static String[] splitPath(HttpServletRequest request) {
        assert (request != null);
        int prefixLength = request.getContextPath().length() + request.getServletPath().length();
        String p = request.getRequestURI().substring(prefixLength);
        if (p.length() == 0) {
            return new String[0];
        }
        String[] result = p.substring(1).split("/");
        for (int i = 0; i < result.length; ++i) {
            result[i] = IOUtils.decodeURL((String)result[i]);
        }
        return result;
    }
}

