/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.ancillary.jsdoc;

import com.google.caja.ancillary.jsdoc.FileSystem;
import com.google.caja.ancillary.jsdoc.JsdocException;
import com.google.caja.ancillary.jsdoc.JsdocMessageType;
import com.google.caja.ancillary.jsdoc.JsdocRewriter;
import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.ParseException;
import com.google.caja.parser.html.DomParser;
import com.google.caja.parser.html.HtmlQuasiBuilder;
import com.google.caja.parser.html.Nodes;
import com.google.caja.reporting.Message;
import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageType;
import com.google.caja.reporting.MessageTypeInt;
import com.google.caja.util.Executor;
import com.google.caja.util.Strings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Writer;
import java.net.URI;
import java.text.DecimalFormat;
import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlRenderer {
    private final FileSystem fs;
    private final File htmlDir;
    private final String title;
    private final Document outDoc;
    private final HtmlQuasiBuilder b;
    private static final DecimalFormat LINE_NUMBER_FORMAT = new DecimalFormat("0000;-000");

    public static void buildHtml(String json, FileSystem fs, File htmlDir, Iterable<CharProducer> sources, MessageContext mc) throws IOException, JsdocException {
        HtmlRenderer r = new HtmlRenderer(fs, htmlDir);
        r.copySupportingFiles();
        r.buildSourceFiles(sources, mc);
        r.buildFiles(json);
        r.dumpJson(json);
    }

    private HtmlRenderer(FileSystem fs, File htmlDir) {
        this.fs = fs;
        this.htmlDir = htmlDir;
        this.title = "JSDoc";
        this.outDoc = DomParser.makeDocument(null, null);
        this.b = HtmlQuasiBuilder.getBuilder(this.outDoc);
    }

    private void copySupportingFiles() throws IOException {
        this.copyResourceTo("jsdoc.css", this.fs.join(this.htmlDir.getPath(), "jsdoc.css"));
        this.copyResourceTo("/js/prettify/prettify.js", this.fs.join(this.htmlDir.getPath(), "prettify.js"));
        this.copyResourceTo("/js/prettify/prettify.css", this.fs.join(this.htmlDir.getPath(), "prettify.css"));
        this.copyResourceTo("searchbox.js", this.fs.join(this.htmlDir.getPath(), "searchbox.js"));
    }

    private void buildFiles(String json) throws IOException, JsdocException {
        try {
            HashMap<String, Object> bindings = new HashMap<String, Object>();
            bindings.put("fileSystem", new FileSystemSandBoxSafe(this.fs));
            bindings.put("docTitle", this.title);
            bindings.put("htmlDir", this.htmlDir.getPath());
            bindings.put("htmlBuilder", new HtmlBuilderSandBoxSafe(this.b));
            bindings.put("stderr", System.err);
            Executor.Factory.createJsExecutor(new Executor.Input(this.getClass(), "jsdoc_html_formatter.js"), new Executor.Input(this.getClass(), "jsdoc_renderer.js"), new Executor.Input("renderHtml(" + json + ");", this.getClass().getSimpleName())).run(bindings, Object.class);
        }
        catch (Executor.MalformedSourceException ex) {
            throw new JsdocException(new Message((MessageTypeInt)MessageType.INTERNAL_ERROR, MessagePart.Factory.valueOf("Script not parseable by Rhino")), (Throwable)ex);
        }
        catch (Executor.AbnormalExitException ex) {
            throw new JsdocException(new Message((MessageTypeInt)JsdocMessageType.SCRIPT_FAILED_AT_RUNTIME, MessagePart.Factory.valueOf(ex.getScriptTrace())), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildSourceFiles(Iterable<CharProducer> sources, MessageContext mc) throws IOException {
        for (CharProducer src : sources) {
            String relUri = JsdocRewriter.format(src.getSourceBreaks(0).source(), mc);
            String relPath = this.fs.join(this.fs.dirname(relUri), "src-" + this.fs.basename(relUri) + ".html");
            String absPath = this.fs.join(this.htmlDir.getPath(), relPath);
            this.fs.mkdir(this.fs.dirname(absPath));
            String rootDirPath = ".";
            String dn = this.fs.dirname(relPath);
            if (dn != null) {
                rootDirPath = "..";
                while ((dn = this.fs.dirname(dn)) != null) {
                    rootDirPath = this.fs.join(dn, "..");
                }
            }
            Writer out = this.fs.write(absPath);
            try {
                this.buildSourceFile(relUri, rootDirPath, src, out);
            }
            finally {
                out.close();
            }
        }
    }

    private void buildSourceFile(String relUri, String rootDirPath, CharProducer src, Writer out) throws IOException {
        String sourceCode = src.toString();
        int startLineNo = src.filePositionForOffsets(0, 0).startLineNo();
        String extension = HtmlRenderer.fileExtension(relUri);
        String lang = "";
        if (extension != null) {
            lang = "lang-" + Strings.toLowerCase(extension);
        }
        out.write(Nodes.render(this.b.substV("<html>\n  <head>\n    <title>@uri  Source Code</title>\n    <link type=text/css rel=stylesheet\n     href='@root_dir/prettify.css'/>\n    <script type=text/javascript\n     src='@root_dir/prettify.js'></script>\n    <style type=text/css>\nbody, .odd { background-color: #fff }\n.even { background-color: #eee }\n    </style>\n  </head>\n  <body onload='@onload'>\n    <h1><tt>@uri</tt> Source Code</h1>\n    <pre class=\"prettyprint @lang\">@source_code</pre>\n  </body>\n</html>", "uri", relUri, "root_dir", rootDirPath, "source_code", this.numberLines(sourceCode, startLineNo), "lang", lang, "onload", sourceCode.length() < 65536 ? "setTimeout(prettyPrint, 250)" : "")));
    }

    private DocumentFragment numberLines(String sourceCode, int lineNo) {
        DocumentFragment numberedLines = this.outDoc.createDocumentFragment();
        for (String line : sourceCode.split("\r\n?|\n")) {
            Node lineMarkup = this.b.substV("<span class='@class'><span class=nocode id='line@num'>@num: </span>@src</span>&#10;", "num", LINE_NUMBER_FORMAT.format(lineNo), "class", (lineNo & 1) == 0 ? "even" : "odd", "src", line);
            if (lineMarkup instanceof DocumentFragment) {
                Node child;
                while ((child = lineMarkup.getFirstChild()) != null) {
                    numberedLines.appendChild(child);
                }
            } else {
                numberedLines.appendChild(lineMarkup);
            }
            ++lineNo;
        }
        return numberedLines;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpJson(String json) throws IOException {
        Writer out = this.fs.write(this.fs.join(this.htmlDir.getPath(), "jsdoc.json"));
        try {
            out.write(json);
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyResourceTo(String resource, String dest) throws IOException {
        InputStream in = this.getClass().getResourceAsStream(resource);
        if (in == null) {
            throw new FileNotFoundException(resource);
        }
        try {
            OutputStream out = this.fs.writeBytes(dest);
            try {
                int n;
                byte[] buf = new byte[4096];
                while ((n = in.read(buf)) > 0) {
                    out.write(buf, 0, n);
                }
            }
            finally {
                out.close();
            }
        }
        finally {
            in.close();
        }
    }

    private static String fileExtension(String uriPath) {
        int slash;
        URI uri = URI.create(uriPath);
        String path = uri.getPath();
        int dot = path.lastIndexOf(46);
        if (dot <= (slash = path.lastIndexOf(47)) || dot + 1 == path.length()) {
            return null;
        }
        return path.substring(dot + 1);
    }

    public static class HtmlBuilderSandBoxSafe {
        private final HtmlQuasiBuilder underlying;

        HtmlBuilderSandBoxSafe(HtmlQuasiBuilder underlying) {
            this.underlying = underlying;
        }

        public Node substV(String quasi, Object ... params) {
            return this.underlying.substV(quasi, params);
        }

        public DocumentFragment toFragment(String html) throws ParseException {
            return this.underlying.toFragment(html);
        }

        public String toHtml(Node node) {
            return Nodes.render(node);
        }
    }

    public static final class FileSystemSandBoxSafe {
        private final FileSystem underlying;

        FileSystemSandBoxSafe(FileSystem fs) {
            this.underlying = fs;
        }

        public String basename(String path) {
            return this.underlying.basename(path);
        }

        public String canonicalPath(String path) throws IOException {
            return this.underlying.canonicalPath(path);
        }

        public String dirname(String path) {
            return this.underlying.dirname(path);
        }

        public boolean exists(String path) {
            return this.underlying.exists(path);
        }

        public boolean isDirectory(String path) {
            return this.underlying.isDirectory(path);
        }

        public boolean isFile(String path) {
            return this.underlying.isFile(path);
        }

        public String join(String dir, String path) {
            return this.underlying.join(dir, path);
        }

        public void mkdir(String path) throws IOException {
            this.underlying.mkdir(path);
        }

        public PrintStream write(String path) throws IOException {
            return new PrintStream(this.underlying.writeBytes(path), false, "UTF-8");
        }
    }
}

