/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.ancillary.servlet;

import com.google.caja.util.Maps;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum Verb {
    DOC("/doc", "generates JSDoc documentation"),
    ECHO("/echo", "echoes the input after optimizing&|minifying"),
    HELP("/help", "shows help info"),
    INDEX("/index", "an interactive HTML form"),
    LINT("/lint", "checks the input for problematic coding practices");

    final String requestPath;
    final String manual;
    private static final Map<String, Verb> BY_REQUEST_PATH;

    private Verb(String requestPath, String manual) {
        this.requestPath = requestPath;
        this.manual = manual;
    }

    static Verb fromReqPath(String reqPath) {
        return BY_REQUEST_PATH.get(reqPath);
    }

    public String toString() {
        return this.requestPath;
    }

    static {
        BY_REQUEST_PATH = Maps.newHashMap();
        for (Verb verb : Verb.values()) {
            BY_REQUEST_PATH.put(verb.requestPath, verb);
        }
    }
}

