/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.quasiliteral;

import com.google.caja.lexer.FilePosition;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.ParseTreeNodeContainer;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.CatchStmt;
import com.google.caja.parser.js.Declaration;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.ExpressionStmt;
import com.google.caja.parser.js.FormalParam;
import com.google.caja.parser.js.FunctionConstructor;
import com.google.caja.parser.js.FunctionDeclaration;
import com.google.caja.parser.js.Identifier;
import com.google.caja.parser.js.MultiDeclaration;
import com.google.caja.parser.js.NullLiteral;
import com.google.caja.parser.js.Reference;
import com.google.caja.parser.js.Statement;
import com.google.caja.parser.quasiliteral.NameContext;
import com.google.caja.parser.quasiliteral.QuasiBuilder;
import com.google.caja.parser.quasiliteral.Rewriter;
import com.google.caja.parser.quasiliteral.RewriterMessageType;
import com.google.caja.parser.quasiliteral.Rule;
import com.google.caja.parser.quasiliteral.RuleDescription;
import com.google.caja.parser.quasiliteral.Scope;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.MessageTypeInt;
import com.google.caja.util.Lists;
import com.google.caja.util.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class AlphaRenamingRewriter
extends Rewriter {
    private final Map<Scope, NameContext<String, ?>> contexts = Maps.newIdentityHashMap();

    AlphaRenamingRewriter(final MessageQueue mq, final NameContext<String, ?> rootContext) {
        super(mq, false, false);
        this.addRules(new Rule[]{new Rule(){

            @RuleDescription(name="rootScope", synopsis="introduces a root scope", reason="lets us rename globals", matches="/* Expression */ @e", substitutes="@e")
            public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
                if (node instanceof Expression && scope == null) {
                    Expression e = (Expression)node;
                    Block bl = new Block(e.getFilePosition(), Collections.singletonList(new ExpressionStmt(e)));
                    scope = Scope.fromProgram(bl, mq);
                    AlphaRenamingRewriter.this.contexts.put(scope, rootContext);
                    return AlphaRenamingRewriter.this.expand(e, scope);
                }
                return NONE;
            }
        }, new Rule(){

            @RuleDescription(name="fns", synopsis="introduces function scope and assigns rewritten names for function names, formals, and locals", reason="", matches="function @name?(@params*) { @body* }", substitutes="function @name?(@params*) { @headDecls?; @body* }")
            public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
                Map<String, ParseTreeNode> bindings;
                FunctionConstructor fc = node instanceof FunctionConstructor ? (FunctionConstructor)node : (node instanceof FunctionDeclaration ? ((FunctionDeclaration)node).getInitializer() : null);
                Map<String, ParseTreeNode> map = bindings = fc != null ? this.match(fc) : null;
                if (bindings != null) {
                    NameContext.VarInfo vi;
                    boolean isDeclaration = fc != node;
                    NameContext context = (NameContext)AlphaRenamingRewriter.this.contexts.get(scope);
                    NameContext newContext = context.makeChildContext();
                    Scope newScope = Scope.fromFunctionConstructor(scope, fc);
                    List<Declaration> headDecls = Lists.newArrayList();
                    if (newScope.hasFreeThis()) {
                        try {
                            vi = newContext.declare("this", FilePosition.UNKNOWN);
                        }
                        catch (NameContext.RedeclarationException ex) {
                            throw new RuntimeException(ex);
                        }
                        headDecls.add((Declaration)QuasiBuilder.substV("var @newName = this", "newName", new Identifier(FilePosition.UNKNOWN, vi.newName)));
                    }
                    if (newScope.hasFreeArguments()) {
                        try {
                            vi = newContext.declare("arguments", FilePosition.UNKNOWN);
                        }
                        catch (NameContext.RedeclarationException ex) {
                            throw new RuntimeException(ex);
                        }
                        headDecls.add((Declaration)QuasiBuilder.substV("var @newName = arguments", "newName", new Identifier(FilePosition.UNKNOWN, vi.newName)));
                    }
                    for (String local : newScope.getLocals()) {
                        try {
                            newContext.declare(local, newScope.getLocationOfDeclaration(local));
                        }
                        catch (NameContext.RedeclarationException ex) {}
                    }
                    AlphaRenamingRewriter.this.contexts.put(newScope, newContext);
                    Identifier name = fc.getIdentifier();
                    Identifier rewrittenName = name.getName() == null ? name : (!2.isSynthetic(name) ? new Identifier(name.getFilePosition(), (isDeclaration ? context : newContext).lookup(name.getName()).newName) : name);
                    List<FormalParam> newFormals = Lists.newArrayList();
                    for (FormalParam p : fc.getParams()) {
                        if (!2.isSynthetic(p.getIdentifier())) {
                            NameContext.VarInfo v = newContext.lookup(p.getIdentifierName());
                            if (v == null) {
                                try {
                                    v = newContext.declare(p.getIdentifierName(), p.getFilePosition());
                                }
                                catch (NameContext.RedeclarationException ex) {
                                    throw new RuntimeException(ex);
                                }
                            }
                            FormalParam newP = new FormalParam(new Identifier(p.getFilePosition(), v.newName));
                            newFormals.add(newP);
                            continue;
                        }
                        newFormals.add(p);
                    }
                    if (isDeclaration && !2.isSynthetic(name) && newScope.isFunction(name.getName()) && !newScope.isDeclaredFunction(name.getName())) {
                        headDecls.add((Declaration)QuasiBuilder.substV("var @innerName = @outerName;", "outerName", new Reference(rewrittenName), "innerName", new Identifier(name.getFilePosition(), newContext.lookup(name.getName()).newName)));
                    }
                    FunctionConstructor out = (FunctionConstructor)this.substV("name", rewrittenName, "headDecls", AlphaRenamingRewriter.optionalDeclarations(headDecls), "params", new ParseTreeNodeContainer(newFormals), "body", this.expandAll(bindings.get("body"), newScope));
                    out.setFilePosition(fc.getFilePosition());
                    return isDeclaration ? new FunctionDeclaration(out) : out;
                }
                return NONE;
            }
        }, new Rule(){

            @RuleDescription(name="block", synopsis="block scoping", reason="", matches="{ @body* }", substitutes="{ @body* }")
            public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
                if (node instanceof Block) {
                    Block bl = (Block)node;
                    List<Statement> stmts = Lists.newArrayList();
                    Scope newScope = Scope.fromPlainBlock(scope);
                    NameContext newContext = ((NameContext)AlphaRenamingRewriter.this.contexts.get(scope)).makeChildContext();
                    AlphaRenamingRewriter.this.contexts.put(newScope, newContext);
                    for (String string : newScope.getLocals()) {
                        try {
                            newContext.declare(string, newScope.getLocationOfDeclaration(string));
                        }
                        catch (NameContext.RedeclarationException ex) {
                            throw new RuntimeException(ex);
                        }
                    }
                    for (Statement statement : bl.children()) {
                        stmts.add((Statement)AlphaRenamingRewriter.this.expand(statement, newScope));
                    }
                    stmts.addAll(0, newScope.getStartStatements());
                    return new Block(bl.getFilePosition(), stmts);
                }
                return NONE;
            }
        }, new Rule(){

            @RuleDescription(name="catch", synopsis="catch block scoping", reason="", matches="catch (@e) { @body* }", substitutes="catch (@e) { @body* }")
            public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
                if (node instanceof CatchStmt) {
                    CatchStmt cs = (CatchStmt)node;
                    Scope newScope = Scope.fromCatchStmt(scope, cs);
                    NameContext context = (NameContext)AlphaRenamingRewriter.this.contexts.get(scope);
                    NameContext newContext = context.makeChildContext();
                    AlphaRenamingRewriter.this.contexts.put(newScope, newContext);
                    try {
                        newContext.declare(cs.getException().getIdentifierName(), cs.getException().getFilePosition());
                    }
                    catch (NameContext.RedeclarationException ex) {
                        ex.toMessageQueue(mq);
                    }
                    return this.expandAll(cs, newScope);
                }
                return NONE;
            }
        }, new Rule(){

            @RuleDescription(name="memberAccess", synopsis="", reason="so that we do not mistakenly rename property names", matches="@o.@r", substitutes="@o.@r")
            public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
                Map<String, ParseTreeNode> bindings = this.match(node);
                if (bindings != null) {
                    return this.substV("o", AlphaRenamingRewriter.this.expand(bindings.get("o"), scope), "r", bindings.get("r"));
                }
                return NONE;
            }
        }, new Rule(){

            @RuleDescription(name="thisReference", synopsis="Disallow this in the global scope.", reason="The declaration cannot be rewritten.", matches="this", substitutes="this")
            public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
                if (this.match(node) != null && scope.isOuter()) {
                    mq.addMessage((MessageTypeInt)RewriterMessageType.THIS_IN_GLOBAL_CONTEXT, node.getFilePosition());
                    return new NullLiteral(node.getFilePosition());
                }
                return NONE;
            }
        }, new Rule(){

            @RuleDescription(name="argumentsReference", synopsis="Disallow arguments in the global scope.", reason="The declaration cannot be rewritten.", matches="arguments", substitutes="arguments")
            public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
                if (this.match(node) != null && scope.isOuter()) {
                    mq.addMessage((MessageTypeInt)RewriterMessageType.ARGUMENTS_IN_GLOBAL_CONTEXT, node.getFilePosition());
                    return new NullLiteral(node.getFilePosition());
                }
                return NONE;
            }
        }, new Rule(){

            @RuleDescription(name="rename", synopsis="", reason="", matches="/* Reference */ @r", substitutes="@r")
            public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
                Reference r;
                if (node instanceof Reference && !8.isSynthetic(r = (Reference)node)) {
                    FilePosition pos = r.getFilePosition();
                    String rname = r.getIdentifierName();
                    NameContext context = (NameContext)AlphaRenamingRewriter.this.contexts.get(scope);
                    NameContext.VarInfo vi = context.lookup(rname);
                    if (vi != null) {
                        return new Reference(new Identifier(pos, vi.newName));
                    }
                    mq.addMessage((MessageTypeInt)RewriterMessageType.FREE_VARIABLE, pos, MessagePart.Factory.valueOf(rname));
                    return new NullLiteral(pos);
                }
                return NONE;
            }
        }, new Rule(){

            @RuleDescription(name="decl", synopsis="rewrite declaration identifiers", reason="", matches="var @i = @v?", substitutes="var @ri = @v?;")
            public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
                Map<String, ParseTreeNode> bindings = this.match(node);
                if (bindings != null) {
                    Identifier ri;
                    Identifier i = (Identifier)bindings.get("i");
                    Expression v = (Expression)bindings.get("v");
                    if (!9.isSynthetic(i)) {
                        NameContext context = (NameContext)AlphaRenamingRewriter.this.contexts.get(scope);
                        NameContext.VarInfo var = context.lookup(i.getName());
                        if (var == null) {
                            return this.expandAll(node, scope);
                        }
                        ri = new Identifier(i.getFilePosition(), var.newName);
                    } else {
                        ri = i;
                    }
                    return this.substV("ri", ri, "v", v != null ? AlphaRenamingRewriter.this.expand(v, scope) : null);
                }
                return NONE;
            }
        }, new Rule(){

            @RuleDescription(name="other", synopsis="", reason="", matches="@n", substitutes="@n")
            public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
                return this.expandAll(node, scope);
            }
        }});
    }

    private static Statement optionalDeclarations(List<Declaration> decls) {
        switch (decls.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return decls.get(0);
            }
        }
        return new MultiDeclaration(FilePosition.UNKNOWN, decls);
    }
}

