/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.render;

import com.google.caja.render.Indent;
import com.google.caja.render.TokenClassification;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Indenter {
    final List<String> tokens;
    final int[] match;
    final boolean[] parenthetical;
    final boolean breakAfterComment;

    Indenter(List<String> tokens, boolean breakAfterComment) {
        this.tokens = tokens;
        this.breakAfterComment = breakAfterComment;
        this.match = new int[tokens.size()];
        this.parenthetical = new boolean[tokens.size()];
        ArrayList<Integer> openBracketStack = new ArrayList<Integer>();
        boolean isParenthetical = false;
        int n = tokens.size();
        block5: for (int i = 0; i < n; ++i) {
            this.parenthetical[i] = isParenthetical;
            String tok = tokens.get(i);
            if (tok.length() != 1) continue;
            switch (tok.charAt(0)) {
                case '(': {
                    openBracketStack.add(i);
                    isParenthetical = true;
                    this.parenthetical[i] = true;
                    continue block5;
                }
                case '[': 
                case '{': {
                    openBracketStack.add(i);
                    isParenthetical = false;
                    continue block5;
                }
                case ')': 
                case ']': 
                case '}': {
                    int last = openBracketStack.size() - 1;
                    if (last >= 0) {
                        int openIdx = (Integer)openBracketStack.remove(last);
                        this.match[openIdx] = i;
                        this.match[i] = openIdx;
                    }
                    isParenthetical = last >= 1 && "(".equals(tokens.get((Integer)openBracketStack.get(last - 1)));
                    continue block5;
                }
                default: {
                    this.match[i] = -1;
                }
            }
        }
        Iterator i$ = openBracketStack.iterator();
        while (i$.hasNext()) {
            int unclosedBracketIdx = (Integer)i$.next();
            this.match[unclosedBracketIdx] = tokens.size();
        }
    }

    void breakLines() {
        int last = this.tokens.size() - 1;
        for (int i = 0; i <= last; ++i) {
            String next2;
            boolean isBreak;
            String next;
            String tok = this.tokens.get(i);
            if (!" ".equals(tok)) continue;
            String prev = i != 0 ? this.tokens.get(i - 1) : null;
            String string = next = i != last ? this.tokens.get(i + 1) : null;
            if ("{".equals(prev)) {
                isBreak = this.match[i - 1] - i > 6;
            } else if ("}".equals(next)) {
                isBreak = i - this.match[i + 1] > 6;
            } else if (";".equals(prev)) {
                isBreak = !this.parenthetical[i];
            } else if ("}".equals(prev)) {
                if ("else".equals(next) || "catch".equals(next) || "finally".equals(next)) {
                    isBreak = false;
                } else if ("while".equals(next)) {
                    isBreak = true;
                    int open = this.match[i - 1];
                    if (open > 0) {
                        int j = open;
                        while (--j >= 0) {
                            String t = this.tokens.get(j);
                            if ("do".equals(t)) {
                                isBreak = false;
                            } else if (TokenClassification.isComment(t) || Character.isWhitespace(t.charAt(0))) continue;
                            break;
                        }
                    }
                } else {
                    isBreak = true;
                }
            } else {
                isBreak = prev != null && TokenClassification.isComment(prev) ? this.breakAfterComment : false;
            }
            if (!isBreak) continue;
            if (next != null && TokenClassification.isComment(next) && i + 2 <= last && ("\n".equals(next2 = this.tokens.get(i + 2)) || " ".equals(next2))) {
                this.tokens.set(i + 2, "\n");
                isBreak = false;
            }
            if (!isBreak) continue;
            this.tokens.set(i, "\n");
        }
    }

    void indent(int lineLengthLimit) {
        int charsInLine = 0;
        LinkedList<Indent> indents = new LinkedList<Indent>();
        int lastBreakPt = -1;
        LinkedList indentsAtLastBreakPt = null;
        int charsInLineAtLastBreakPt = -1;
        indents.add(new Indent(0, false));
        int n = this.tokens.size();
        for (int i = 0; i < n; ++i) {
            String tok = this.tokens.get(i);
            if (lastBreakPt >= 0 && (charsInLine += tok.length()) >= lineLengthLimit && !" ".equals(tok) && !"\n".equals(tok)) {
                if (" ".equals(this.tokens.get(lastBreakPt))) {
                    this.tokens.set(lastBreakPt, "\n");
                    i = lastBreakPt - 1;
                } else {
                    this.tokens.add(lastBreakPt + 1, "\n");
                    i = lastBreakPt;
                }
                lastBreakPt = -1;
                indents = indentsAtLastBreakPt;
                charsInLine = charsInLineAtLastBreakPt;
                continue;
            }
            if (tok.length() != 1) {
                if (TokenClassification.isComment(tok)) continue;
                indents.set(0, ((Indent)indents.get(0)).withInStatement(true));
                continue;
            }
            switch (tok.charAt(0)) {
                case '(': 
                case '[': {
                    int indentLevel = Math.min(charsInLine, ((Indent)indents.get((int)0)).spaces + 2);
                    indents.addFirst(new Indent(indentLevel, this.parenthetical[i]));
                    break;
                }
                case '{': {
                    indents.set(0, ((Indent)indents.get(0)).withInStatement(false));
                    indents.addFirst(new Indent(((Indent)indents.get((int)0)).spaces + 2, false));
                    break;
                }
                case '}': {
                    if (indents.size() > 1) {
                        indents.removeFirst();
                    }
                    indents.set(0, ((Indent)indents.get(0)).withInStatement(false));
                    break;
                }
                case ')': 
                case ']': {
                    if (indents.size() <= 1) break;
                    indents.removeFirst();
                    break;
                }
                case ' ': {
                    break;
                }
                case '\n': {
                    String nextToken;
                    if (i + 1 < n && !"\n".equals(nextToken = this.tokens.get(i + 1))) {
                        charsInLine = ((Indent)indents.get(0)).getIndentLevel();
                        if (nextToken.length() == 1) {
                            switch (nextToken.charAt(0)) {
                                case ')': 
                                case ']': 
                                case '}': {
                                    if (indents.size() <= 1) break;
                                    charsInLine = ((Indent)indents.get((int)1)).spaces;
                                }
                            }
                        } else if ("case".equals(nextToken) || "default".equals(nextToken)) {
                            charsInLine = Math.max(charsInLine - 2, 0);
                        }
                        this.tokens.set(i, Indenter.makeIndent(charsInLine));
                    }
                    lastBreakPt = -1;
                    break;
                }
                case ',': 
                case ':': 
                case ';': {
                    indents.set(0, ((Indent)indents.get(0)).withInStatement(false));
                    break;
                }
                default: {
                    indents.set(0, ((Indent)indents.get(0)).withInStatement(true));
                }
            }
            switch (tok.charAt(0)) {
                case ' ': 
                case ')': 
                case ']': 
                case '}': {
                    lastBreakPt = i;
                    indentsAtLastBreakPt = new LinkedList(indents);
                    charsInLineAtLastBreakPt = charsInLine;
                }
            }
        }
    }

    private static String makeIndent(int nSpaces) {
        StringBuilder sb = new StringBuilder(nSpaces + 1);
        sb.append('\n');
        while (nSpaces >= 16) {
            sb.append("                ");
            nSpaces -= 16;
        }
        sb.append("                ", 0, nSpaces);
        return sb.toString();
    }
}

