/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.reporting;

import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.MessageType;
import com.google.caja.reporting.MessageTypeInt;
import com.google.caja.reporting.SimpleMessageQueue;
import java.io.IOException;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class BuildInfo {
    private static BuildInfo instance;
    private ResourceBundle properties;

    public static BuildInfo getInstance() {
        if (instance == null) {
            instance = new BuildInfo();
        }
        return instance;
    }

    BuildInfo(ResourceBundle properties) {
        this.properties = properties;
    }

    protected BuildInfo() {
        try {
            this.properties = ResourceBundle.getBundle("com/google/caja/reporting/buildInfo");
        }
        catch (MissingResourceException e) {
            this.properties = null;
        }
    }

    private String getPropertyValue(String name) {
        if (this.properties != null) {
            try {
                return this.properties.getString(name);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return "<unknown>";
    }

    private MessagePart wrapValue(final String value) {
        return new MessagePart(){

            public void format(MessageContext context, Appendable out) throws IOException {
                out.append(value);
            }
        };
    }

    public void addBuildInfo(MessageQueue mq) {
        mq.addMessage((MessageTypeInt)MessageType.BUILD_INFO, this.wrapValue(this.getBuildVersion()), this.wrapValue(this.getBuildTimestamp()));
    }

    public String getBuildInfo() {
        SimpleMessageQueue mq = new SimpleMessageQueue();
        this.addBuildInfo(mq);
        return mq.getMessages().get(0).format(new MessageContext());
    }

    public String getBuildVersion() {
        return this.getPropertyValue("svnVersion");
    }

    public String getBuildTimestamp() {
        return this.getPropertyValue("timestamp");
    }

    public long getCurrentTime() {
        return System.currentTimeMillis();
    }
}

