/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.reporting;

import com.google.caja.lexer.TokenConsumer;

public class RenderContext {
    private final boolean embeddable;
    private final boolean asciiOnly;
    private final boolean json;
    private final boolean asXml;
    private final boolean rawObjKeys;
    private final TokenConsumer out;

    public RenderContext(TokenConsumer out) {
        this(true, false, false, false, false, out);
    }

    private RenderContext(boolean asciiOnly, boolean embeddable, boolean json, boolean asXml, boolean rawObjKeys, TokenConsumer out) {
        if (null == out) {
            throw new NullPointerException();
        }
        this.embeddable = embeddable;
        this.asciiOnly = asciiOnly;
        this.json = json;
        this.asXml = asXml;
        this.rawObjKeys = rawObjKeys;
        this.out = out;
    }

    public final boolean isEmbeddable() {
        return this.embeddable;
    }

    public final boolean isAsciiOnly() {
        return this.asciiOnly;
    }

    public final boolean asJson() {
        return this.json;
    }

    public final boolean asXml() {
        return this.asXml;
    }

    public final boolean rawObjKeys() {
        return this.rawObjKeys;
    }

    public final TokenConsumer getOut() {
        return this.out;
    }

    public RenderContext withAsciiOnly(boolean b) {
        return b != this.asciiOnly ? new RenderContext(b, this.embeddable, this.json, this.asXml, this.rawObjKeys, this.out) : this;
    }

    public RenderContext withEmbeddable(boolean b) {
        return b != this.embeddable ? new RenderContext(this.asciiOnly, b, this.json, this.asXml, this.rawObjKeys, this.out) : this;
    }

    public RenderContext withJson(boolean b) {
        return b != this.json ? new RenderContext(this.asciiOnly, this.embeddable, b, this.asXml, this.rawObjKeys, this.out) : this;
    }

    public RenderContext withAsXml(boolean b) {
        return b != this.asXml ? new RenderContext(this.asciiOnly, this.embeddable, this.json, b, this.rawObjKeys, this.out) : this;
    }

    public RenderContext withRawObjKeys(boolean b) {
        return b != this.asXml ? new RenderContext(this.asciiOnly, this.embeddable, this.json, this.asXml, b, this.out) : this;
    }
}

