/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.authz.aop;

import java.lang.annotation.Annotation;
import java.util.Set;
import org.jsecurity.authz.AuthorizationException;
import org.jsecurity.authz.UnauthorizedException;
import org.jsecurity.authz.annotation.RequiresPermissions;
import org.jsecurity.authz.aop.AuthorizingAnnotationHandler;
import org.jsecurity.subject.Subject;
import org.jsecurity.util.PermissionUtils;

public class PermissionAnnotationHandler
extends AuthorizingAnnotationHandler {
    public PermissionAnnotationHandler() {
        super(RequiresPermissions.class);
    }

    protected String getAnnotationValue(Annotation a) {
        RequiresPermissions rpAnnotation = (RequiresPermissions)a;
        return rpAnnotation.value();
    }

    public void assertAuthorized(Annotation a) throws AuthorizationException {
        if (!(a instanceof RequiresPermissions)) {
            return;
        }
        String p = this.getAnnotationValue(a);
        Set<String> perms = PermissionUtils.toPermissionStrings(p);
        Subject subject = this.getSubject();
        if (perms.size() == 1) {
            if (!subject.isPermitted(perms.iterator().next())) {
                String msg = "Calling Subject does not have required permission [" + p + "].  " + "Method invocation denied.";
                throw new UnauthorizedException(msg);
            }
        } else {
            String[] permStrings = new String[perms.size()];
            if (!subject.isPermittedAll(permStrings = perms.toArray(permStrings))) {
                String msg = "Calling Subject does not have required permissions [" + p + "].  " + "Method invocation denied.";
                throw new UnauthorizedException(msg);
            }
        }
    }
}

