/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.session.mgt.quartz;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsecurity.session.mgt.SessionValidationScheduler;
import org.jsecurity.session.mgt.ValidatingSessionManager;
import org.jsecurity.session.mgt.quartz.QuartzSessionValidationJob;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;

public class QuartzSessionValidationScheduler
implements SessionValidationScheduler {
    public static final long DEFAULT_SESSION_VALIDATION_INTERVAL = 3600000L;
    private static final String JOB_NAME = "SessionValidationJob";
    private static final Log log = LogFactory.getLog(QuartzSessionValidationScheduler.class);
    private Scheduler scheduler;
    private boolean schedulerImplicitlyCreated = false;
    private boolean enabled = false;
    private ValidatingSessionManager sessionManager;
    private long sessionValidationInterval = 3600000L;

    public QuartzSessionValidationScheduler() {
    }

    public QuartzSessionValidationScheduler(ValidatingSessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    protected Scheduler getScheduler() throws SchedulerException {
        if (this.scheduler == null) {
            this.scheduler = StdSchedulerFactory.getDefaultScheduler();
            this.schedulerImplicitlyCreated = true;
        }
        return this.scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public void setSessionManager(ValidatingSessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setSessionValidationInterval(long sessionValidationInterval) {
        this.sessionValidationInterval = sessionValidationInterval;
    }

    public void enableSessionValidation() {
        block6: {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Scheduling session validation job using Quartz with session validation interval of [" + this.sessionValidationInterval + "]ms..."));
            }
            try {
                SimpleTrigger trigger = new SimpleTrigger(this.getClass().getName(), "DEFAULT", SimpleTrigger.REPEAT_INDEFINITELY, this.sessionValidationInterval);
                JobDetail detail = new JobDetail(JOB_NAME, "DEFAULT", QuartzSessionValidationJob.class);
                detail.getJobDataMap().put((Object)"sessionManager", (Object)this.sessionManager);
                Scheduler scheduler = this.getScheduler();
                scheduler.scheduleJob(detail, (Trigger)trigger);
                if (this.schedulerImplicitlyCreated) {
                    scheduler.start();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Successfully started implicitly created Quartz Scheduler instance.");
                    }
                }
                this.enabled = true;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Session validation job successfully scheduled with Quartz.");
                }
            }
            catch (SchedulerException e) {
                if (!log.isErrorEnabled()) break block6;
                log.error((Object)"Error starting the Quartz session validation job.  Session validation may not occur.", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableSessionValidation() {
        Scheduler scheduler;
        block16: {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Stopping Quartz session validation job...");
            }
            try {
                scheduler = this.getScheduler();
                if (scheduler == null) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)"getScheduler() method returned a null Quartz scheduler, which is unexpected.  Please check your configuration and/or implementation.  Returning quietly since there is no validation job to remove (scheduler does not exist).");
                    }
                    return;
                }
            }
            catch (SchedulerException e) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)"Unable to acquire Quartz Scheduler.  Ignoring and returning (already stopped?)", (Throwable)e);
                }
                return;
            }
            try {
                scheduler.unscheduleJob(JOB_NAME, "DEFAULT");
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Quartz session validation job stopped successfully.");
                }
            }
            catch (SchedulerException e) {
                if (!log.isDebugEnabled()) break block16;
                log.debug((Object)"Could not cleanly remove SessionValidationJob from Quartz scheduler.  Ignoring and stopping.", (Throwable)e);
            }
        }
        this.enabled = false;
        if (this.schedulerImplicitlyCreated) {
            try {
                scheduler.shutdown();
            }
            catch (SchedulerException e) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)"Unable to cleanly shutdown implicitly created Quartz Scheduler instance.", (Throwable)e);
                }
            }
            finally {
                this.setScheduler(null);
                this.schedulerImplicitlyCreated = false;
            }
        }
    }
}

