/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionUtils {
    public static <E> Collection<E> emptyCollection(Class<E> clazz) {
        return Collections.EMPTY_SET;
    }

    public static <E> Set<E> asSet(E ... elements) {
        if (elements == null || elements.length == 0) {
            return Collections.EMPTY_SET;
        }
        LinkedHashSet set = new LinkedHashSet(elements.length * 4 / 3 + 1);
        Collections.addAll(set, elements);
        return set;
    }

    public static <E> List<E> asList(E ... elements) {
        if (elements == null || elements.length == 0) {
            return Collections.EMPTY_LIST;
        }
        int capacity = CollectionUtils.computeListCapacity(elements.length);
        ArrayList list = new ArrayList(capacity);
        Collections.addAll(list, elements);
        return list;
    }

    static int computeListCapacity(int arraySize) {
        return (int)Math.min(5L + (long)arraySize + (long)(arraySize / 10), Integer.MAX_VALUE);
    }
}

