/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.web.session;

import java.io.Serializable;
import java.net.InetAddress;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.jsecurity.authz.AuthorizationException;
import org.jsecurity.authz.HostUnauthorizedException;
import org.jsecurity.session.InvalidSessionException;
import org.jsecurity.session.Session;
import org.jsecurity.session.mgt.AbstractSessionManager;
import org.jsecurity.web.WebUtils;
import org.jsecurity.web.session.WebSession;
import org.jsecurity.web.session.WebSessionManager;

public class ServletContainerSessionManager
extends AbstractSessionManager
implements WebSessionManager {
    protected Session doGetSession(Serializable sessionId) throws InvalidSessionException {
        ServletRequest request = WebUtils.getRequiredServletRequest();
        ServletResponse response = WebUtils.getRequiredServletResponse();
        return this.getSession(request, response);
    }

    public Session getSession(ServletRequest request, ServletResponse response) throws AuthorizationException {
        Session session = null;
        HttpSession httpSession = ((HttpServletRequest)request).getSession(false);
        if (httpSession != null) {
            session = this.createSession(httpSession, WebUtils.getInetAddress(request));
        }
        return session;
    }

    protected Session createSession(InetAddress originatingHost) throws HostUnauthorizedException, IllegalArgumentException {
        ServletRequest request = WebUtils.getRequiredServletRequest();
        HttpSession httpSession = ((HttpServletRequest)request).getSession();
        return this.createSession(httpSession, originatingHost);
    }

    protected Session createSession(HttpSession httpSession, InetAddress inet) {
        return new WebSession(httpSession, inet);
    }
}

