/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.htmlparser.sax;

import nu.validator.htmlparser.common.XmlViolationPolicy;
import nu.validator.htmlparser.impl.TreeBuilder;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SAXStreamer
extends TreeBuilder<Attributes> {
    private ContentHandler contentHandler = null;
    private LexicalHandler lexicalHandler = null;
    private int depth = -1;

    SAXStreamer() {
        super(XmlViolationPolicy.FATAL, false);
    }

    @Override
    protected void addAttributesToElement(Attributes element, Attributes attributes) throws SAXException {
        Attributes existingAttrs = element;
        for (int i = 0; i < attributes.getLength(); ++i) {
            String qName = attributes.getQName(i);
            if (existingAttrs.getIndex(qName) >= 0) continue;
            this.fatal();
        }
    }

    @Override
    protected void appendCharacters(Attributes parent, char[] buf, int start, int length) throws SAXException {
        this.contentHandler.characters(buf, start, length);
    }

    @Override
    protected void appendChildrenToNewParent(Attributes oldParent, Attributes newParent) throws SAXException {
        this.fatal();
    }

    @Override
    protected void appendComment(Attributes parent, char[] buf, int start, int length) throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.comment(buf, start, length);
        }
    }

    @Override
    protected void appendCommentToDocument(char[] buf, int start, int length) throws SAXException {
        if (this.lexicalHandler != null) {
            if (this.depth == 0) {
                this.lexicalHandler.comment(buf, start, length);
            } else {
                this.fatal();
            }
        }
    }

    @Override
    protected Attributes createElement(String name, Attributes attributes) throws SAXException {
        return attributes;
    }

    @Override
    protected Attributes createHtmlElementSetAsRoot(Attributes attributes) throws SAXException {
        return attributes;
    }

    @Override
    protected void detachFromParent(Attributes element) throws SAXException {
        this.fatal();
    }

    @Override
    protected void detachFromParentAndAppendToNewParent(Attributes child, Attributes newParent) throws SAXException {
    }

    @Override
    protected boolean hasChildren(Attributes element) throws SAXException {
        return false;
    }

    @Override
    protected void insertBefore(Attributes child, Attributes sibling, Attributes parent) throws SAXException {
        this.fatal();
    }

    @Override
    protected void insertCharactersBefore(char[] buf, int start, int length, Attributes sibling, Attributes parent) throws SAXException {
        this.fatal();
    }

    @Override
    protected Attributes parentElementFor(Attributes child) throws SAXException {
        this.fatal();
        throw new RuntimeException("Unreachable");
    }

    @Override
    protected Attributes shallowClone(Attributes element) throws SAXException {
        return element;
    }

    public void setContentHandler(ContentHandler handler) {
        this.contentHandler = handler;
    }

    public void setLexicalHandler(LexicalHandler handler) {
        this.lexicalHandler = handler;
    }

    @Override
    protected void appendDoctypeToDocument(String name, String publicIdentifier, String systemIdentifier) throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startDTD(name, publicIdentifier, systemIdentifier);
            this.lexicalHandler.endDTD();
        }
    }

    @Override
    protected void bodyClosed(Attributes body) throws SAXException {
        this.contentHandler.endElement("http://www.w3.org/1999/xhtml", "body", "body");
        --this.depth;
    }

    @Override
    protected void elementPopped(String name, Attributes node) throws SAXException {
        this.contentHandler.endElement("http://www.w3.org/1999/xhtml", name, name);
        --this.depth;
    }

    @Override
    protected void elementPushed(String name, Attributes node) throws SAXException {
        if (this.depth == 0) {
            this.contentHandler.startPrefixMapping("", "http://www.w3.org/1999/xhtml");
        }
        this.contentHandler.startElement("http://www.w3.org/1999/xhtml", name, name, node);
        ++this.depth;
    }

    @Override
    protected void end() throws SAXException {
        this.depth = -1;
        this.contentHandler.endDocument();
    }

    @Override
    protected void htmlClosed(Attributes html) throws SAXException {
        this.contentHandler.endElement("http://www.w3.org/1999/xhtml", "html", "html");
        this.contentHandler.endPrefixMapping("");
        --this.depth;
    }

    @Override
    protected void start(boolean fragment) throws SAXException {
        if (this.depth > -1) {
            this.depth = -1;
            this.fatal();
        }
        this.contentHandler.setDocumentLocator(this.tokenizer);
        if (fragment) {
            this.depth = 1;
        } else {
            this.depth = 0;
            this.contentHandler.startDocument();
        }
    }
}

