/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.opensocial.gadgets.service;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.nuxeo.opensocial.gadgets.helper.GadgetI18nHelper;
import org.nuxeo.opensocial.gadgets.service.api.GadgetDeclaration;
import org.nuxeo.opensocial.gadgets.service.api.GadgetService;
import org.nuxeo.runtime.api.Framework;

public abstract class BaseGadgetDescriptor
implements Serializable,
GadgetDeclaration {
    private static final long serialVersionUID = 1L;
    protected static final Log log = LogFactory.getLog(BaseGadgetDescriptor.class);
    protected GadgetSpec cachedSpec = null;

    @Override
    public GadgetSpec getGadgetSpec() {
        if (this.cachedSpec != null) {
            return this.cachedSpec;
        }
        try {
            return ((GadgetService)Framework.getLocalService(GadgetService.class)).getGadgetSpec(this);
        }
        catch (Exception e) {
            log.error((Object)("Error while getting gadget spec for gadget " + this.getName()), (Throwable)e);
            return null;
        }
    }

    protected String getDescriptionFromSpec() {
        if (this.getGadgetSpec() == null) {
            return null;
        }
        return this.getGadgetSpec().getModulePrefs().getDescription();
    }

    @Override
    public String getTitle() {
        if (this.getGadgetSpec() == null) {
            return this.getName();
        }
        return this.getGadgetSpec().getModulePrefs().getTitle();
    }

    @Override
    public String getTitle(Locale locale) {
        String name = this.getName();
        String title = GadgetI18nHelper.getI18nGadgetTitle(name, locale);
        if (title.equals(name)) {
            return this.getTitle();
        }
        return title;
    }

    @Override
    public String getDescription(Locale locale) {
        String name = this.getName();
        String description = GadgetI18nHelper.getI18nGadgetDescription(name, locale);
        if (description.equals(name)) {
            return this.getDescription();
        }
        return description;
    }

    @Override
    public String getAuthor() {
        if (this.getGadgetSpec() == null) {
            if (!this.isExternal()) {
                return "Nuxeo";
            }
            return null;
        }
        return this.getGadgetSpec().getModulePrefs().getAuthor();
    }

    @Override
    public String getScreenshot() {
        if (this.getGadgetSpec() == null) {
            return null;
        }
        Uri uri = this.getGadgetSpec().getModulePrefs().getScreenshot();
        if (uri == null) {
            return this.getThumbnail();
        }
        return uri.toString();
    }

    @Override
    public String getThumbnail() {
        if (this.getGadgetSpec() == null) {
            return null;
        }
        Uri uri = this.getGadgetSpec().getModulePrefs().getThumbnail();
        if (uri == null) {
            return null;
        }
        return uri.toString();
    }

    @Override
    public String getPublicGadgetDefinition() throws MalformedURLException {
        return this.getGadgetDefinition().toString();
    }
}

