/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.shindig.gadgets.spec.Feature;
import org.apache.shindig.gadgets.spec.GadgetSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentRewriterFeature {
    protected static final String INCLUDE_URLS = "include-urls";
    protected static final String EXCLUDE_URLS = "exclude-urls";
    protected static final String INCLUDE_URL = "include-url";
    protected static final String EXCLUDE_URL = "exclude-url";
    protected static final String INCLUDE_TAGS = "include-tags";
    protected static final String EXPIRES = "expires";
    public static final String EXPIRES_DEFAULT = "HTTP";
    protected Set<String> includeTags;
    protected PATTERNS includePatterns;
    protected PATTERNS excludePatterns;
    protected Pattern includePattern;
    protected Pattern excludePattern;
    protected Pattern excludeOverridePattern;
    protected Collection<String> includes;
    protected Collection<String> excludes;
    protected Integer expires;
    protected Integer fingerprint;

    public ContentRewriterFeature(GadgetSpec spec, String defaultInclude, String defaultExclude, String defaultExpires, Set<String> defaultTags, boolean onlyAllowExcludes) {
        Feature f = null;
        if (spec != null) {
            f = spec.getModulePrefs().getFeatures().get("content-rewrite");
        }
        this.setUpIncludes(f, defaultInclude, onlyAllowExcludes);
        this.setUpExcludes(f, defaultExclude, onlyAllowExcludes);
        this.setUpIncludeTags(f, defaultTags, onlyAllowExcludes);
        this.setUpExpires(f, defaultExpires, onlyAllowExcludes);
    }

    protected void setUpExpires(Feature f, String defaultExpires, boolean onlyAllowExcludes) {
        Integer defaultExpiresVal = null;
        try {
            defaultExpiresVal = new Integer(defaultExpires);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        ArrayList expiresOptions = Lists.newArrayListWithCapacity((int)3);
        if (f != null && f.getParams().containsKey((Object)EXPIRES)) {
            String p = this.normalizeParam(f.getParam(EXPIRES), null);
            Integer expiresParamVal = null;
            try {
                expiresParamVal = new Integer(p);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (!onlyAllowExcludes || defaultExpiresVal == null || expiresParamVal != null && expiresParamVal < defaultExpiresVal) {
                expiresOptions.add(p);
            }
        }
        expiresOptions.add(defaultExpires);
        expiresOptions.add(EXPIRES_DEFAULT);
        for (String expiryOption : expiresOptions) {
            try {
                this.expires = new Integer(expiryOption);
            }
            catch (NumberFormatException nfe) {
                if (!EXPIRES_DEFAULT.equalsIgnoreCase(expiryOption)) continue;
            }
            break;
        }
    }

    protected void setUpIncludeTags(Feature f, Set<String> defaultTags, boolean onlyAllowExcludes) {
        String includeTagList;
        this.includeTags = ImmutableSortedSet.copyOf(defaultTags);
        if (f != null && (includeTagList = f.getParam(INCLUDE_TAGS)) != null) {
            TreeSet tags = Sets.newTreeSet();
            for (String tag : includeTagList.split(",")) {
                if (tag == null) continue;
                tags.add(tag.trim().toLowerCase());
            }
            if (onlyAllowExcludes) {
                tags.retainAll(defaultTags);
            }
            this.includeTags = tags;
        }
    }

    protected void setUpIncludes(Feature f, String defaultInclude, boolean onlyAllowExcludes) {
        String includeRegex = this.normalizeParam(defaultInclude, null);
        if (f != null && !onlyAllowExcludes) {
            Collection<String> includeUrls;
            if (f.getParams().containsKey((Object)INCLUDE_URLS)) {
                includeRegex = this.normalizeParam(f.getParam(INCLUDE_URLS), includeRegex);
            }
            if ((includeUrls = f.getParamCollection(INCLUDE_URL)).size() == 0) {
                this.includes = Collections.emptyList();
            } else if (includeUrls.contains("*")) {
                this.includes = Collections.singleton("*");
            } else {
                this.includes = new ArrayList<String>(includeUrls.size());
                for (String s : includeUrls) {
                    if (s.length() <= 0) continue;
                    this.includes.add(s.toLowerCase());
                }
            }
        } else {
            this.includes = Collections.emptyList();
        }
        if (this.includes.size() == 0 && (includeRegex == null || "".equals(includeRegex))) {
            this.includePatterns = PATTERNS.NONE;
        } else if (this.includes.size() > 0) {
            this.includePatterns = this.includes.size() == 1 && "*".equals(this.includes.iterator().next()) ? PATTERNS.ALL : PATTERNS.STRINGS;
        } else {
            this.includePatterns = ".*".equals(includeRegex) ? PATTERNS.ALL : PATTERNS.REGEX;
            this.includePattern = Pattern.compile(includeRegex);
        }
    }

    protected void setUpExcludes(Feature f, String defaultExclude, boolean onlyAllowExcludes) {
        String excludeOverrideRegex;
        String excludeRegex = this.normalizeParam(defaultExclude, null);
        String string = excludeOverrideRegex = onlyAllowExcludes ? excludeRegex : null;
        if (f != null) {
            Collection<String> excludeUrls;
            if (f.getParams().containsKey((Object)EXCLUDE_URLS)) {
                excludeRegex = this.normalizeParam(f.getParam(EXCLUDE_URLS), null);
            }
            if ((excludeUrls = f.getParamCollection(EXCLUDE_URL)).size() == 0) {
                this.excludes = Collections.emptyList();
            } else if (excludeUrls.contains("*")) {
                this.excludes = Collections.singleton("*");
            } else {
                this.excludes = new ArrayList<String>(excludeUrls.size());
                excludeRegex = null;
                for (String s : excludeUrls) {
                    if (s.length() <= 0) continue;
                    this.excludes.add(s.toLowerCase());
                }
            }
        } else {
            this.excludes = Collections.emptyList();
        }
        if (this.excludes.size() == 0 && (excludeRegex == null || "".equals(excludeRegex))) {
            this.excludePatterns = PATTERNS.NONE;
        } else if (this.excludes.size() > 0) {
            this.excludePatterns = this.excludes.size() == 1 && "*".equals(this.excludes.iterator().next()) ? PATTERNS.ALL : PATTERNS.STRINGS;
        } else {
            this.excludePatterns = ".*".equals(excludeRegex) ? PATTERNS.ALL : PATTERNS.REGEX;
            this.excludePattern = Pattern.compile(excludeRegex);
        }
        if (excludeOverrideRegex != null && !excludeOverrideRegex.equals(excludeRegex)) {
            this.excludeOverridePattern = Pattern.compile(excludeOverrideRegex);
            if (this.excludePatterns == PATTERNS.NONE) {
                this.excludePatterns = PATTERNS.REGEX;
            }
        }
    }

    protected String normalizeParam(String paramValue, String defaultVal) {
        if (paramValue == null) {
            return defaultVal;
        }
        if ((paramValue = paramValue.trim()).length() == 0) {
            return defaultVal;
        }
        return paramValue;
    }

    protected boolean shouldInclude(String url) {
        switch (this.includePatterns) {
            case NONE: {
                return false;
            }
            case ALL: {
                return true;
            }
            case REGEX: {
                return this.includePattern.matcher(url).find();
            }
            case STRINGS: {
                String urllc = url.toLowerCase();
                for (String substr : this.includes) {
                    if (urllc.indexOf(substr) < 0) continue;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    protected boolean shouldExclude(String url) {
        switch (this.excludePatterns) {
            case NONE: {
                return false;
            }
            case ALL: {
                return true;
            }
            case REGEX: {
                return this.excludeOverridePattern != null && this.excludeOverridePattern.matcher(url).find() || this.excludePattern != null && this.excludePattern.matcher(url).find();
            }
            case STRINGS: {
                if (this.excludeOverridePattern != null && this.excludeOverridePattern.matcher(url).find()) {
                    return true;
                }
                String urllc = url.toLowerCase();
                for (String substr : this.excludes) {
                    if (urllc.indexOf(substr) < 0) continue;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public boolean isRewriteEnabled() {
        return this.includePatterns != PATTERNS.NONE && this.excludePatterns != PATTERNS.ALL;
    }

    public boolean shouldRewriteURL(String url) {
        return this.shouldInclude(url) && !this.shouldExclude(url);
    }

    public boolean shouldRewriteTag(String tag) {
        if (tag != null) {
            return this.includeTags.contains(tag.toLowerCase());
        }
        return false;
    }

    public Set<String> getIncludedTags() {
        return this.includeTags;
    }

    public Integer getExpires() {
        return this.expires;
    }

    public int getFingerprint() {
        if (this.fingerprint == null) {
            int result = this.includePattern != null ? this.includePattern.pattern().hashCode() : 0;
            for (String s : this.includes) {
                result = 31 * result + s.hashCode();
            }
            result = 31 * result + (this.excludePattern != null ? this.excludePattern.pattern().hashCode() : 0);
            for (String s : this.excludes) {
                result = 31 * result + s.hashCode();
            }
            for (String s : this.includeTags) {
                result = 31 * result + s.hashCode();
            }
            this.fingerprint = result;
        }
        return this.fingerprint;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum PATTERNS {
        ALL,
        NONE,
        REGEX,
        STRINGS;

    }
}

