/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.social.workspace.activity;

import java.util.Collection;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.nuxeo.ecm.activity.AbstractActivityUpgrader;
import org.nuxeo.ecm.activity.ActivitiesListImpl;
import org.nuxeo.ecm.activity.Activity;
import org.nuxeo.ecm.activity.ActivityBuilder;
import org.nuxeo.ecm.activity.ActivityStreamService;
import org.nuxeo.ecm.activity.ActivityStreamServiceImpl;

public class SocialWorkspaceMembersActivityUpgrader
extends AbstractActivityUpgrader {
    public void doUpgrade(ActivityStreamService activityStreamService) {
        EntityManager em = ((ActivityStreamServiceImpl)activityStreamService).getEntityManager();
        Query query = em.createQuery("select activity from Activity activity where activity.verb = :verb and activity.actor like :actor");
        query.setParameter("verb", (Object)"socialworkspace:members");
        query.setParameter("actor", (Object)"doc:%");
        ActivitiesListImpl activities = new ActivitiesListImpl((Collection)query.getResultList());
        for (Activity activity : activities) {
            String oldActor = activity.getActor();
            String oldDisplayActor = activity.getDisplayActor();
            String oldObject = activity.getObject();
            String oldDisplayObject = activity.getDisplayObject();
            activity.setActor(oldObject);
            activity.setDisplayActor(oldDisplayObject);
            activity.setObject(oldActor);
            activity.setDisplayObject(oldDisplayActor);
            activity.setTarget(oldActor);
            activity.setDisplayTarget(oldDisplayActor);
            activity.setContext(oldDisplayActor);
            em.merge((Object)activity);
            Activity newActivity = new ActivityBuilder(activity).context(null).build();
            em.persist((Object)newActivity);
        }
    }
}

