/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.social.workspace.userregistration;

import java.io.Serializable;
import java.security.Principal;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.social.workspace.adapters.SocialWorkspace;
import org.nuxeo.ecm.social.workspace.helper.SocialWorkspaceHelper;
import org.nuxeo.ecm.social.workspace.service.SocialWorkspaceService;
import org.nuxeo.ecm.user.registration.DefaultRegistrationUserFactory;
import org.nuxeo.runtime.api.Framework;

public class SocialRegistrationUserFactory
extends DefaultRegistrationUserFactory {
    public static final String NOT_NOTIFY_MEMBER_FIELD = "socialer:doNotNotifyMembers";
    public static final String ADMINISTRATOR_RIGHT = "administrator";
    public static final String MEMBER_RIGHT = "member";
    private static final Log log = LogFactory.getLog(SocialRegistrationUserFactory.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentModel doAddDocumentPermission(CoreSession session, DocumentModel registrationDoc) throws ClientException {
        String docId = (String)((Object)registrationDoc.getPropertyValue("docinfo:documentId"));
        if (StringUtils.isBlank((String)docId)) {
            throw new ClientException("SocialWorkspace id is missing");
        }
        SocialWorkspace sw = SocialWorkspaceHelper.toSocialWorkspace(session.getDocument((DocumentRef)new IdRef(docId)));
        if (sw == null) {
            throw new ClientException("Document passed is not a Social Workspace");
        }
        String login = (String)((Object)registrationDoc.getPropertyValue("userinfo:login"));
        NuxeoPrincipal principal = this.getUserManager().getPrincipal(login);
        sw.getDocument().putContextData("memberNotificationDisabled", registrationDoc.getPropertyValue(NOT_NOTIFY_MEMBER_FIELD));
        Boolean isAdded = ADMINISTRATOR_RIGHT.equals(registrationDoc.getPropertyValue("docinfo:permission")) ? Boolean.valueOf(this.getSocialWorkspaceService().addSocialWorkspaceAdministrator(sw, (Principal)principal)) : Boolean.valueOf(this.getSocialWorkspaceService().addSocialWorkspaceMember(sw, (Principal)principal));
        try {
            DocumentModel documentModel = isAdded != false ? sw.getDocument() : null;
            return documentModel;
        }
        finally {
            sw.getDocument().putContextData("memberNotificationDisabled", (Serializable)Boolean.valueOf(false));
        }
    }

    public void doPostAddDocumentPermission(CoreSession session, DocumentModel registrationDoc, DocumentModel document) throws ClientException {
    }

    public SocialWorkspaceService getSocialWorkspaceService() {
        return (SocialWorkspaceService)Framework.getLocalService(SocialWorkspaceService.class);
    }

    public UserManager getUserManager() {
        return (UserManager)Framework.getLocalService(UserManager.class);
    }
}

