/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.picture;

import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.imaging.jpeg.JpegSegmentReader;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.MetadataReader;
import com.drew.metadata.exif.ExifReader;
import com.drew.metadata.iptc.IptcDirectory;
import com.drew.metadata.iptc.IptcReader;
import com.drew.metadata.jpeg.JpegCommentReader;
import com.drew.metadata.jpeg.JpegReader;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IPTCHelper {
    private static final Log log = LogFactory.getLog(IPTCHelper.class);

    public static void extractMetadata(InputStream stream, Map<String, Object> metadata) throws JpegProcessingException {
        JpegSegmentReader reader = new JpegSegmentReader(stream);
        IPTCHelper.extractMetadataFromSegment(metadata, reader, (byte)-31, ExifReader.class);
        IPTCHelper.extractMetadataFromSegment(metadata, reader, (byte)-19, IptcReader.class);
        IPTCHelper.extractMetadataFromSegment(metadata, reader, (byte)-64, JpegReader.class);
        IPTCHelper.extractMetadataFromSegment(metadata, reader, (byte)-2, JpegCommentReader.class);
    }

    public static void extractMetadataFromSegment(Map<String, Object> metadata, JpegSegmentReader reader, byte marker, Class<? extends MetadataReader> klass) {
        try {
            Constructor<? extends MetadataReader> constructor = klass.getConstructor(byte[].class);
            int n = reader.getSegmentCount(marker);
            for (int i = 0; i < n; ++i) {
                byte[] segment = reader.readSegment(marker, i);
                Metadata md = new Metadata();
                constructor.newInstance(new Object[]{segment}).extract(md);
                IPTCHelper.extract(md, metadata);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public static void extract(Metadata md, Map<String, Object> metadata) {
        Directory iptc = md.getDirectory(IptcDirectory.class);
        if (iptc.containsTag(592)) {
            metadata.put("byLine", IPTCHelper.cleanupData(iptc.getString(592)));
        }
        if (iptc.containsTag(597)) {
            metadata.put("byLineTitle", IPTCHelper.cleanupData(iptc.getString(597)));
        }
        if (iptc.containsTag(632)) {
            metadata.put("caption", IPTCHelper.cleanupData(iptc.getString(632)));
        }
        if (iptc.containsTag(527)) {
            metadata.put("category", IPTCHelper.cleanupData(iptc.getString(527)));
        }
        if (iptc.containsTag(602)) {
            metadata.put("city", IPTCHelper.cleanupData(iptc.getString(602)));
        }
        if (iptc.containsTag(628)) {
            metadata.put("copyrightNotice", IPTCHelper.cleanupData(iptc.getString(628)));
        }
        if (iptc.containsTag(613)) {
            metadata.put("countryOrPrimaryLocation", IPTCHelper.cleanupData(iptc.getString(613)));
        }
        if (iptc.containsTag(622)) {
            metadata.put("credit", IPTCHelper.cleanupData(iptc.getString(622)));
        }
        if (iptc.containsTag(567)) {
            try {
                metadata.put("dateCreated", iptc.getDate(567));
            }
            catch (MetadataException e) {
                log.error((Object)"Failed to get IPTC - date created", (Throwable)e);
            }
        }
        if (iptc.containsTag(617)) {
            metadata.put("headline", IPTCHelper.cleanupData(iptc.getString(617)));
        }
        if (iptc.containsTag(537)) {
            metadata.put("keywords", IPTCHelper.cleanupData(iptc.getString(537)));
        }
        if (iptc.containsTag(135)) {
            metadata.put("language", IPTCHelper.cleanupData(iptc.getString(135)));
        }
        if (iptc.containsTag(517)) {
            metadata.put("objectName", IPTCHelper.cleanupData(iptc.getString(517)));
        }
        if (iptc.containsTag(615)) {
            metadata.put("originalTransmissionReference", IPTCHelper.cleanupData(iptc.getString(615)));
        }
        if (iptc.containsTag(577)) {
            metadata.put("originatingProgram", IPTCHelper.cleanupData(iptc.getString(577)));
        }
        if (iptc.containsTag(607)) {
            metadata.put("provinceOrState", IPTCHelper.cleanupData(iptc.getString(607)));
        }
        if (iptc.containsTag(607)) {
            metadata.put("provinceOrState", IPTCHelper.cleanupData(iptc.getString(607)));
        }
        if (iptc.containsTag(512)) {
            metadata.put("recordVersion", IPTCHelper.cleanupData(iptc.getString(512)));
        }
        if (iptc.containsTag(542)) {
            try {
                metadata.put("releaseDate", iptc.getDate(542));
            }
            catch (MetadataException e) {
                log.error((Object)"Failed to get IPTC - release date", (Throwable)e);
            }
        }
        if (iptc.containsTag(547)) {
            metadata.put("releaseTime", IPTCHelper.cleanupData(iptc.getString(547)));
        }
        if (iptc.containsTag(627)) {
            metadata.put("source", IPTCHelper.cleanupData(iptc.getString(627)));
        }
        if (iptc.containsTag(552)) {
            metadata.put("specialInstructions", IPTCHelper.cleanupData(iptc.getString(552)));
        }
        if (iptc.containsTag(532)) {
            metadata.put("supplementalCategories", IPTCHelper.cleanupData(iptc.getString(532)));
        }
        if (iptc.containsTag(572)) {
            metadata.put("timeCreated", IPTCHelper.cleanupData(iptc.getString(572)));
        }
        if (iptc.containsTag(522)) {
            metadata.put("urgency", IPTCHelper.cleanupData(iptc.getString(522)));
        }
        if (iptc.containsTag(634)) {
            metadata.put("writer", IPTCHelper.cleanupData(iptc.getString(634)));
        }
    }

    public static String cleanupData(String data) {
        if (data != null) {
            return data.replace("\u0000", "");
        }
        return null;
    }
}

