/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.picture;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.work.AbstractWork;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.platform.picture.api.adapters.PictureResourceAdapter;
import org.nuxeo.runtime.api.Framework;

public class PictureViewsGenerationWork
extends AbstractWork {
    private static final long serialVersionUID = 1L;
    public static final String CATEGORY_PICTURE_GENERATION = "pictureViewsGeneration";
    public static final String PICTURE_VIEWS_GENERATION_DONE_EVENT = "pictureViewsGenerationDone";
    protected final String xpath;

    public PictureViewsGenerationWork(String repositoryName, String docId, String xpath) {
        super(repositoryName + ':' + docId + ':' + xpath + ":pictureView");
        this.setDocument(repositoryName, docId);
        this.xpath = xpath;
    }

    public String getCategory() {
        return CATEGORY_PICTURE_GENERATION;
    }

    public String getTitle() {
        return "Picture views generation";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void work() throws Exception {
        DocumentModel workingDocument = null;
        this.setProgress(Work.Progress.PROGRESS_INDETERMINATE);
        this.setStatus("Extracting");
        try {
            this.initSession();
            if (!this.session.exists((DocumentRef)new IdRef(this.docId))) {
                this.setStatus("Nothing to process");
                return;
            }
            workingDocument = this.session.getDocument((DocumentRef)new IdRef(this.docId));
            workingDocument.detach(true);
            this.commitOrRollbackTransaction();
        }
        finally {
            this.cleanUp(true, null);
        }
        this.setStatus("Generating views");
        Property fileProp = workingDocument.getProperty(this.xpath);
        ArrayList pictureTemplates = null;
        PictureResourceAdapter picture = (PictureResourceAdapter)workingDocument.getAdapter(PictureResourceAdapter.class);
        Blob blob = (Blob)fileProp.getValue();
        String filename = blob == null ? null : blob.getFilename();
        String title = workingDocument.getTitle();
        picture.fillPictureViews(blob, filename, title, pictureTemplates);
        this.startTransaction();
        this.initSession();
        if (!this.session.exists((DocumentRef)new IdRef(this.docId))) {
            this.setStatus("Nothing to process");
            return;
        }
        this.setStatus("Saving");
        if (workingDocument.isVersion()) {
            workingDocument.putContextData("allowVersionWrite", (Serializable)Boolean.TRUE);
        }
        this.session.saveDocument(workingDocument);
        this.firePictureViewsGenerationDoneEvent(workingDocument);
        this.setStatus("Done");
    }

    protected void firePictureViewsGenerationDoneEvent(DocumentModel doc) throws ClientException {
        WorkManager workManager = (WorkManager)Framework.getLocalService(WorkManager.class);
        List workIds = workManager.listWorkIds(CATEGORY_PICTURE_GENERATION, null);
        int worksCount = 0;
        for (String workId : workIds) {
            if (!workId.equals(this.getId()) || ++worksCount <= 1) continue;
            return;
        }
        DocumentEventContext ctx = new DocumentEventContext(this.session, this.session.getPrincipal(), doc);
        Event event = ctx.newEvent(PICTURE_VIEWS_GENERATION_DONE_EVENT);
        ((EventService)Framework.getLocalService(EventService.class)).fireEvent(event);
    }
}

