/*
 * (C) Copyright 2010 Nuxeo SAS (http://nuxeo.com/) and contributors.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser General Public License
 * (LGPL) version 2.1 which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl.html
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * Contributors:
 * Thomas Roger
 */

package org.nuxeo.ecm.spaces.api;

/**
 * @author <a href="mailto:troger@nuxeo.com">Thomas Roger</a>
 */
public class Constants {

    private Constants() {
        // Constants class
    }

    public static final String SPACE_DOCUMENT_TYPE = "Space";

    public static final String UNIT_DOCUMENT_TYPE = "Unit";

    public static final String OPEN_SOCIAL_GADGET_DOCUMENT_TYPE = "WCOpenSocial";


    public static final String WEB_CONTENT_SCHEMA = "webcontent";

    public static final String WEB_CONTENT_TITLE_PROPERTY = "webcontent:title";

    public static final String WEB_CONTENT_POSITION_PROPERTY = "webcontent:position";

    public static final String WEB_CONTENT_IS_COLLAPSED_PROPERTY = "webcontent:iscollapsed";

    public static final String WEB_CONTENT_IS_IN_A_PORTLET_PROPERTY = "webcontent:isinaportlet";

    public static final String WEB_CONTENT_PREFERENCES_PROPERTY = "webcontent:preferences";

    public static final String WC_HTML_SCHEMA = "wchtml";

    public static final String WC_HTML_HTML_PROPERTY = "wchtml:html";

    public static final String WC_HTML_HTML_TITLE_PROPERTY = "wchtml:htmltitle";

    public static final String WC_HTML_HTML_TEMPLATE_PROPERTY = "template";

    public static final String WC_OPEN_SOCIAL_SCHEMA = "wcopensocial";

    public static final String WC_OPEN_SOCIAL_GADGET_NAME = "wcopensocial:gadgetname";

    public static final String WC_OPEN_SOCIAL_GADGET_DEF_URL_PROPERTY = "wcopensocial:gadgetDefUrl";

    public static final String WC_OPEN_SOCIAL_USER_PREFS_PROPERTY = "wcopensocial:userPrefs";

}
