/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.realm;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jsecurity.authc.Account;
import org.jsecurity.authc.AuthenticationException;
import org.jsecurity.authc.AuthenticationInfo;
import org.jsecurity.authc.AuthenticationToken;
import org.jsecurity.authc.ExpiredCredentialsException;
import org.jsecurity.authc.LockedAccountException;
import org.jsecurity.authc.SimpleAccount;
import org.jsecurity.authc.UsernamePasswordToken;
import org.jsecurity.authz.AuthorizationInfo;
import org.jsecurity.authz.SimpleAuthorizingAccount;
import org.jsecurity.authz.SimpleRole;
import org.jsecurity.realm.AuthorizingRealm;
import org.jsecurity.subject.PrincipalCollection;
import org.jsecurity.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleAccountRealm
extends AuthorizingRealm {
    protected Map<String, SimpleRole> roles = null;

    public SimpleAccountRealm() {
        this.init();
    }

    public SimpleAccountRealm(String name) {
        this.setName(name);
        this.init();
    }

    @Override
    public void afterAuthorizationCacheSet() {
        this.initRoleCache();
        this.afterRoleCacheSet();
    }

    public void afterRoleCacheSet() {
    }

    protected void initRoleCache() {
        if (this.getAuthorizationCache() == null) {
            this.initAuthorizationCache();
        }
        this.roles = new HashMap<String, SimpleRole>();
        this.accountAndRoleCachesCreated();
    }

    protected SimpleAccount getUser(String username) {
        return (SimpleAccount)this.getAuthorizationCache().get(username);
    }

    public boolean accountExists(String username) {
        return this.getUser(username) != null;
    }

    public void addAccount(String username, String password) {
        this.addAccount(username, password, null);
    }

    public void addAccount(String username, String password, String ... roles) {
        Set<String> roleNames = CollectionUtils.asSet(roles);
        SimpleAuthorizingAccount account = new SimpleAuthorizingAccount(username, (Object)password, this.getName(), roleNames, null);
        this.add(account);
    }

    protected void add(SimpleAccount account) {
        Object key = this.getAuthorizationCacheKey(account.getPrincipals());
        this.getAuthorizationCache().put(key, account);
    }

    protected SimpleRole getRole(String rolename) {
        return this.roles.get(rolename);
    }

    public boolean roleExists(String name) {
        return this.getRole(name) != null;
    }

    public void addRole(String name) {
        this.add(new SimpleRole(name));
    }

    protected void add(SimpleRole role) {
        this.roles.put(role.getName(), role);
    }

    protected static Set<String> toSet(String delimited, String delimiter) {
        String[] rolenamesArray;
        if (delimited == null || delimited.trim().equals("")) {
            return null;
        }
        HashSet<String> values = new HashSet<String>();
        for (String s : rolenamesArray = delimited.split(delimiter)) {
            String trimmed = s.trim();
            if (trimmed.length() <= 0) continue;
            values.add(trimmed);
        }
        return values;
    }

    protected void accountAndRoleCachesCreated() {
    }

    @Override
    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        UsernamePasswordToken upToken = (UsernamePasswordToken)token;
        SimpleAccount account = (SimpleAccount)this.getAuthorizationCache().get(upToken.getUsername());
        if (account.isLocked()) {
            throw new LockedAccountException("Account [" + account + "] is locked.");
        }
        if (account.isCredentialsExpired()) {
            String msg = "The credentials for account [" + account + "] are expired";
            throw new ExpiredCredentialsException(msg);
        }
        return account;
    }

    @Override
    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        return (Account)this.getAuthorizationCache().get(this.getAuthorizationCacheKey(principals));
    }

    @Override
    protected Object getAuthorizationCacheKey(PrincipalCollection principals) {
        return principals.fromRealm(this.getName()).iterator().next();
    }
}

