/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.activity.operations;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.map.ObjectMapper;
import org.nuxeo.ecm.activity.ActivityHelper;
import org.nuxeo.ecm.activity.ActivityLinkBuilder;
import org.nuxeo.ecm.activity.ActivityMessageHelper;
import org.nuxeo.ecm.activity.ActivityReply;
import org.nuxeo.ecm.activity.ActivityStreamService;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.impl.blob.InputStreamBlob;
import org.nuxeo.runtime.api.Framework;

@Operation(id="Services.AddActivityReply", category="Services", label="Add a reply to an existing activity", description="Add a reply to an existing activity.")
public class AddActivityReply {
    public static final String ID = "Services.AddActivityReply";
    private static final Log log = LogFactory.getLog(AddActivityReply.class);
    @Context
    protected CoreSession session;
    @Context
    protected ActivityStreamService activityStreamService;
    @Param(name="language", required=false)
    protected String language;
    @Param(name="activityId", required=true)
    protected String activityId;
    @Param(name="message", required=true)
    protected String message;
    @Param(name="activityLinkBuilderName", required=true)
    protected String activityLinkBuilderName;

    @OperationMethod
    public Blob run() throws IOException {
        String actor = ActivityHelper.createUserActivityObject(this.session.getPrincipal());
        String displayActor = ActivityHelper.generateDisplayName(this.session.getPrincipal());
        ActivityReply reply = new ActivityReply(actor, displayActor, this.message, new Date().getTime());
        reply = this.activityStreamService.addActivityReply(Long.valueOf(this.activityId), reply);
        Locale locale = this.language != null && !this.language.isEmpty() ? new Locale(this.language) : Locale.ENGLISH;
        DateFormat dateFormat = DateFormat.getDateInstance(2, locale);
        ActivityLinkBuilder activityLinkBuilder = ((ActivityStreamService)Framework.getLocalService(ActivityStreamService.class)).getActivityLinkBuilder(this.activityLinkBuilderName);
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("id", reply.getId());
        m.put("actor", reply.getActor());
        m.put("displayActor", reply.getDisplayActor());
        m.put("displayActorLink", this.getDisplayActorLink(reply.getActor(), reply.getDisplayActor(), activityLinkBuilder));
        m.put("actorAvatarURL", activityLinkBuilder.getUserAvatarURL(this.session, ActivityHelper.getUsername(reply.getActor())));
        m.put("message", ActivityMessageHelper.replaceURLsByLinks(reply.getMessage()));
        m.put("publishedDate", dateFormat.format(new Date(reply.getPublishedDate())));
        String username = ActivityHelper.getUsername(reply.getActor());
        m.put("allowDeletion", this.session.getPrincipal().getName().equals(username));
        ObjectMapper mapper = new ObjectMapper();
        StringWriter writer = new StringWriter();
        mapper.writeValue((Writer)writer, m);
        return new InputStreamBlob((InputStream)new ByteArrayInputStream(writer.toString().getBytes("UTF-8")), "application/json");
    }

    protected String getDisplayActorLink(String actor, String displayActor, ActivityLinkBuilder activityLinkBuilder) {
        return activityLinkBuilder.getUserProfileLink(actor, displayActor);
    }
}

