/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.agenda.operations;

import java.util.Date;
import org.joda.time.DateTime;
import org.nuxeo.ecm.agenda.AgendaEventBuilder;
import org.nuxeo.ecm.agenda.AgendaService;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;

@Operation(id="VEVENT.Create", category="Document", label="Create Event", description="Create a new Event document")
public class CreateAgendaEvent {
    protected static final String ID = "VEVENT.Create";
    @Context
    protected CoreSession session;
    @Context
    protected AgendaService agendaService;
    @Param(name="summary")
    protected String summary;
    @Param(name="dtStart")
    protected Date dtStart;
    @Param(name="dtEnd", required=false)
    protected Date dtEnd;
    @Param(name="contextPath", required=false)
    protected String contextPath;
    @Param(name="description", required=false)
    protected String description = "";
    @Param(name="location", required=false)
    protected String location = "";

    @OperationMethod
    public void run() throws ClientException {
        if (this.dtEnd == null) {
            this.dtEnd = new DateTime((Object)this.dtStart).plusHours(1).toDate();
        }
        AgendaEventBuilder aeb = AgendaEventBuilder.build(this.summary, this.dtStart, this.dtEnd).description(this.description).location(this.location);
        this.agendaService.createEvent(this.session, this.contextPath, aeb.toMap());
    }
}

