/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.render;

import com.google.inject.Inject;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.apache.sanselan.ImageFormat;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.Sanselan;
import org.apache.sanselan.common.byteSources.ByteSource;
import org.apache.sanselan.common.byteSources.ByteSourceInputStream;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.parse.caja.CajaCssSanitizer;
import org.apache.shindig.gadgets.render.SanitizingProxyingLinkRewriter;
import org.apache.shindig.gadgets.render.SanitizingProxyingLinkRewriterFactory;
import org.apache.shindig.gadgets.rewrite.ContentRewriterFeature;
import org.apache.shindig.gadgets.rewrite.ContentRewriterFeatureFactory;
import org.apache.shindig.gadgets.rewrite.LinkRewriter;
import org.apache.shindig.gadgets.rewrite.MutableContent;
import org.apache.shindig.gadgets.rewrite.RequestRewriter;

public class SanitizingRequestRewriter
implements RequestRewriter {
    private static final Logger logger = Logger.getLogger(SanitizingRequestRewriter.class.getName());
    private final CajaCssSanitizer cssSanitizer;
    private final ContentRewriterFeatureFactory rewriterFeatureFactory;
    private final SanitizingProxyingLinkRewriterFactory sanitizingProxyingLinkRewriterFactory;

    @Inject
    public SanitizingRequestRewriter(ContentRewriterFeatureFactory rewriterFeatureFactory, CajaCssSanitizer cssSanitizer, SanitizingProxyingLinkRewriterFactory sanitizingProxyingLinkRewriterFactory) {
        this.cssSanitizer = cssSanitizer;
        this.rewriterFeatureFactory = rewriterFeatureFactory;
        this.sanitizingProxyingLinkRewriterFactory = sanitizingProxyingLinkRewriterFactory;
    }

    public boolean rewrite(HttpRequest request, HttpResponse resp, MutableContent content) {
        if (request.isSanitizationRequested()) {
            ContentRewriterFeature rewriterFeature = this.rewriterFeatureFactory.createRewriteAllFeature(request.getCacheTtl());
            if (StringUtils.isEmpty((String)request.getRewriteMimeType())) {
                logger.log(Level.WARNING, "Request to sanitize without content type for " + request.getUri());
                content.setContent("");
                return true;
            }
            if (request.getRewriteMimeType().equalsIgnoreCase("text/css")) {
                return this.rewriteProxiedCss(request, resp, content, rewriterFeature);
            }
            if (request.getRewriteMimeType().toLowerCase().startsWith("image/")) {
                return this.rewriteProxiedImage(request, resp, content);
            }
            logger.log(Level.WARNING, "Request to sanitize unknown content type " + request.getRewriteMimeType() + " for " + request.getUri());
            content.setContent("");
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean rewriteProxiedImage(HttpRequest request, HttpResponse resp, MutableContent content) {
        boolean imageIsSafe = false;
        try {
            String contentType = resp.getHeader("Content-Type");
            if (contentType == null || contentType.toLowerCase().startsWith("image/")) {
                try {
                    ImageFormat imageFormat = Sanselan.guessFormat((ByteSource)new ByteSourceInputStream(resp.getResponse(), request.getUri().getPath()));
                    if (imageFormat == ImageFormat.IMAGE_FORMAT_UNKNOWN) {
                        logger.log(Level.INFO, "Unable to sanitize unknown image type " + request.getUri().toString());
                        boolean bl = true;
                        return bl;
                    }
                    imageIsSafe = true;
                    boolean bl = false;
                    return bl;
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
                catch (ImageReadException ire) {
                    logger.log(Level.INFO, "Unable to detect image type for " + request.getUri().toString() + " for sanitized content", ire);
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (!imageIsSafe) {
                content.setContent("");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean rewriteProxiedCss(HttpRequest request, HttpResponse response, MutableContent content, ContentRewriterFeature rewriterFeature) {
        String sanitized = "";
        try {
            String contentType = response.getHeader("Content-Type");
            if (contentType == null || contentType.toLowerCase().startsWith("text/")) {
                SanitizingProxyingLinkRewriter cssImportRewriter = this.sanitizingProxyingLinkRewriterFactory.create(request.getGadget(), rewriterFeature, request.getContainer(), "text/css", false, request.getIgnoreCache());
                SanitizingProxyingLinkRewriter cssImageRewriter = this.sanitizingProxyingLinkRewriterFactory.create(request.getGadget(), rewriterFeature, request.getContainer(), "image/*", false, request.getIgnoreCache());
                sanitized = this.cssSanitizer.sanitize(content.getContent(), request.getUri(), (LinkRewriter)cssImportRewriter, (LinkRewriter)cssImageRewriter);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            content.setContent(sanitized);
        }
    }
}

