/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.rating;

import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.activity.ActivitiesList;
import org.nuxeo.ecm.activity.Activity;
import org.nuxeo.ecm.activity.ActivityBuilder;
import org.nuxeo.ecm.activity.ActivityHelper;
import org.nuxeo.ecm.activity.ActivityStreamService;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.rating.RatingActivityStreamFilter;
import org.nuxeo.ecm.rating.api.RatingService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.DefaultComponent;

public class RatingServiceImpl
extends DefaultComponent
implements RatingService {
    private static final Log log = LogFactory.getLog(RatingServiceImpl.class);

    public void rate(String username, int rating, String activityObject, String aspect) {
        Activity activity = new ActivityBuilder().verb("rating:" + aspect).actor(ActivityHelper.createUserActivityObject((String)username)).target(activityObject).object(String.valueOf(rating)).build();
        ActivityStreamService activityStreamService = (ActivityStreamService)Framework.getLocalService(ActivityStreamService.class);
        activityStreamService.addActivity(activity);
        this.addSuperSpaceRate(activity);
    }

    public void cancelRate(String username, String activityObject, String aspect) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("queryTypeParameter", (Object)RatingActivityStreamFilter.QueryType.GET_RATINGS_FOR_CANCEL);
        parameters.put("actor", ActivityHelper.createUserActivityObject((String)username));
        parameters.put("targetObject", activityObject);
        parameters.put("aspect", aspect);
        ActivityStreamService activityStreamService = (ActivityStreamService)Framework.getLocalService(ActivityStreamService.class);
        ActivitiesList activities = activityStreamService.query("RatingActivityStreamFilter", parameters);
        activityStreamService.removeActivities((Collection)activities);
    }

    public void cancelRates(String activityObject, String aspect) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("queryTypeParameter", (Object)RatingActivityStreamFilter.QueryType.GET_RATINGS_FOR_CANCEL);
        parameters.put("targetObject", activityObject);
        parameters.put("aspect", aspect);
        ActivityStreamService activityStreamService = (ActivityStreamService)Framework.getLocalService(ActivityStreamService.class);
        ActivitiesList activities = activityStreamService.query("RatingActivityStreamFilter", parameters);
        activityStreamService.removeActivities((Collection)activities);
    }

    public boolean hasUserRated(String username, String activityObject, String aspect) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("queryTypeParameter", (Object)RatingActivityStreamFilter.QueryType.GET_ACTOR_RATINGS_FOR_OBJECT);
        parameters.put("actor", ActivityHelper.createUserActivityObject((String)username));
        parameters.put("targetObject", activityObject);
        parameters.put("aspect", aspect);
        ActivityStreamService activityStreamService = (ActivityStreamService)Framework.getLocalService(ActivityStreamService.class);
        ActivitiesList activities = activityStreamService.query("RatingActivityStreamFilter", parameters);
        return !activities.isEmpty();
    }

    public long getRatesCount(String activityObject, String aspect) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("queryTypeParameter", (Object)RatingActivityStreamFilter.QueryType.GET_RATINGS_FOR_OBJECT);
        parameters.put("targetObject", activityObject);
        parameters.put("aspect", aspect);
        ActivityStreamService activityStreamService = (ActivityStreamService)Framework.getLocalService(ActivityStreamService.class);
        ActivitiesList activities = activityStreamService.query("RatingActivityStreamFilter", parameters);
        return activities.size();
    }

    public long getRatesCount(String activityObject, int rating, String aspect) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("queryTypeParameter", (Object)RatingActivityStreamFilter.QueryType.GET_RATINGS_FOR_OBJECT);
        parameters.put("targetObject", activityObject);
        parameters.put("aspect", aspect);
        parameters.put("rating", rating);
        ActivityStreamService activityStreamService = (ActivityStreamService)Framework.getLocalService(ActivityStreamService.class);
        ActivitiesList activities = activityStreamService.query("RatingActivityStreamFilter", parameters);
        return activities.size();
    }

    public long getRatesCountForUser(String username, String activityObject, String aspect) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("queryTypeParameter", (Object)RatingActivityStreamFilter.QueryType.GET_ACTOR_RATINGS_FOR_OBJECT);
        parameters.put("actor", ActivityHelper.createUserActivityObject((String)username));
        parameters.put("targetObject", activityObject);
        parameters.put("aspect", aspect);
        ActivityStreamService activityStreamService = (ActivityStreamService)Framework.getLocalService(ActivityStreamService.class);
        ActivitiesList activities = activityStreamService.query("RatingActivityStreamFilter", parameters);
        return activities.size();
    }

    public long getRatesCountForUser(String username, String activityObject, int rating, String aspect) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("queryTypeParameter", (Object)RatingActivityStreamFilter.QueryType.GET_ACTOR_RATINGS_FOR_OBJECT);
        parameters.put("actor", ActivityHelper.createUserActivityObject((String)username));
        parameters.put("targetObject", activityObject);
        parameters.put("aspect", aspect);
        parameters.put("rating", rating);
        ActivityStreamService activityStreamService = (ActivityStreamService)Framework.getLocalService(ActivityStreamService.class);
        ActivitiesList activities = activityStreamService.query("RatingActivityStreamFilter", parameters);
        return activities.size();
    }

    public double getAverageRating(String activityObject, String aspect) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("queryTypeParameter", (Object)RatingActivityStreamFilter.QueryType.GET_RATINGS_FOR_OBJECT);
        parameters.put("targetObject", activityObject);
        parameters.put("aspect", aspect);
        ActivityStreamService activityStreamService = (ActivityStreamService)Framework.getLocalService(ActivityStreamService.class);
        ActivitiesList activities = activityStreamService.query("RatingActivityStreamFilter", parameters);
        return this.computeAverage(activities);
    }

    public double getAverageRatingForUser(String username, String activityObject, String aspect) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("queryTypeParameter", (Object)RatingActivityStreamFilter.QueryType.GET_ACTOR_RATINGS_FOR_OBJECT);
        parameters.put("actor", ActivityHelper.createUserActivityObject((String)username));
        parameters.put("targetObject", activityObject);
        parameters.put("aspect", aspect);
        ActivityStreamService activityStreamService = (ActivityStreamService)Framework.getLocalService(ActivityStreamService.class);
        ActivitiesList activities = activityStreamService.query("RatingActivityStreamFilter", parameters);
        return this.computeAverage(activities);
    }

    public ActivitiesList getRatedChildren(String activityObject, int rating, String aspect) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("queryTypeParameter", (Object)RatingActivityStreamFilter.QueryType.GET_RATED_CHILDREN_FOR_CONTEXT);
        parameters.put("context", activityObject);
        parameters.put("aspect", aspect);
        parameters.put("rating", rating);
        ActivityStreamService activityStreamService = (ActivityStreamService)Framework.getLocalService(ActivityStreamService.class);
        return activityStreamService.query("RatingActivityStreamFilter", parameters);
    }

    public ActivitiesList getLastestRatedDocByUser(String username, String aspect, int limit) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("queryTypeParameter", (Object)RatingActivityStreamFilter.QueryType.GET_LATEST_RATED_FOR_OBJECT);
        parameters.put("actor", ActivityHelper.createUserActivityObject((String)username));
        parameters.put("aspect", aspect);
        ActivityStreamService activityStreamService = (ActivityStreamService)Framework.getLocalService(ActivityStreamService.class);
        return activityStreamService.query("RatingActivityStreamFilter", parameters, 0L, (long)limit);
    }

    private double computeAverage(ActivitiesList activities) {
        double average = 0.0;
        for (Activity activity : activities) {
            try {
                average += (double)Integer.valueOf(activity.getObject()).intValue();
            }
            catch (NumberFormatException e) {
                log.warn((Object)(activity.getObject() + " is not a valid rating"));
            }
        }
        return average / (double)activities.size();
    }

    protected void addSuperSpaceRate(final Activity fromActivity) {
        final String activityObject = fromActivity.getTarget();
        if (!ActivityHelper.isDocument((String)activityObject)) {
            return;
        }
        final ActivityStreamService activityStreamService = (ActivityStreamService)Framework.getLocalService(ActivityStreamService.class);
        try {
            new UnrestrictedSessionRunner(ActivityHelper.getRepositoryName((String)activityObject)){

                public void run() throws ClientException {
                    IdRef docId = new IdRef(ActivityHelper.getDocumentId((String)activityObject));
                    for (DocumentModel parent : this.session.getParentDocuments((DocumentRef)docId)) {
                        if (!parent.hasFacet("SuperSpace")) continue;
                        Activity activity = new ActivityBuilder(fromActivity).context(ActivityHelper.createDocumentActivityObject((DocumentModel)parent)).build();
                        activityStreamService.addActivity(activity);
                    }
                }
            }.runUnrestricted();
        }
        catch (ClientException e) {
            log.info((Object)"Unable to found SuperSpaces for recomputing their rates", (Throwable)e);
        }
    }
}

