/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.ancillary.servlet;

import com.google.caja.ancillary.jsdoc.FileSystem;
import com.google.caja.ancillary.servlet.Content;
import com.google.caja.ancillary.servlet.Job;
import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.InputSource;
import com.google.caja.util.Maps;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

class ZipFileSystem
implements FileSystem {
    private final String root;
    private final URI rootUri;
    private final Map<String, Content> files = Maps.newLinkedHashMap();
    private static final Pattern BAD_PATH = Pattern.compile("(?:^|/)(?:\\.\\.?)(?:/|$)");
    private static final Content DIRECTORY = null;

    ZipFileSystem(String root) {
        if (!root.startsWith("/") || root.endsWith("/")) {
            throw new IllegalArgumentException(root);
        }
        this.root = root;
        this.rootUri = ZipFileSystem.fileUriWithPath(root + "/");
        this.files.put("/", DIRECTORY);
        this.files.put(root, DIRECTORY);
    }

    private static URI fileUriWithPath(String path) {
        try {
            return new URI("file", null, path, null, null);
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }

    public String basename(String path) {
        int end;
        for (end = path.length(); end > 0 && path.charAt(end - 1) == '/'; --end) {
        }
        if (end == 0 && path.length() != 0) {
            return "/";
        }
        int lastSlash = path.lastIndexOf(47, end - 1);
        return path.substring(lastSlash + 1, end);
    }

    public String canonicalPath(String path) throws IOException {
        URI canon = this.rootUri.resolve(path);
        if (canon == null) {
            throw new IOException(path);
        }
        String canonPath = canon.getPath();
        if (BAD_PATH.matcher(canonPath).find()) {
            throw new IOException(path);
        }
        if ((canonPath = canonPath.replaceAll("/{2,}", "/")).endsWith("/") && !"/".equals(canonPath)) {
            canonPath = canonPath.substring(0, canonPath.length() - 1);
        }
        if (this.root.equals(canonPath) || canonPath.startsWith(this.root + "/")) {
            return canonPath;
        }
        throw new IOException(path);
    }

    public String dirname(String path) {
        int end;
        for (end = path.length(); end > 0 && path.charAt(end - 1) == '/'; --end) {
        }
        if (end == 0 && path.length() != 0) {
            return "/";
        }
        int lastSlash = path.lastIndexOf(47, end - 1);
        if (lastSlash < 0) {
            return null;
        }
        if (lastSlash == 0) {
            return "/";
        }
        return path.substring(0, lastSlash);
    }

    public boolean exists(String path) {
        try {
            path = this.canonicalPath(path);
        }
        catch (IOException ex) {
            return false;
        }
        return this.files.containsKey(path);
    }

    public boolean isDirectory(String path) {
        try {
            path = this.canonicalPath(path);
        }
        catch (IOException ex) {
            return false;
        }
        return this.files.containsKey(path) && DIRECTORY == this.files.get(path);
    }

    public boolean isFile(String path) {
        try {
            path = this.canonicalPath(path);
        }
        catch (IOException ex) {
            return false;
        }
        return this.files.get(path) != DIRECTORY;
    }

    public String join(String dir, String path) {
        if (path == null) {
            throw new NullPointerException();
        }
        if (path.startsWith("/")) {
            throw new IllegalArgumentException(path);
        }
        if (dir == null || "".equals(dir)) {
            return path;
        }
        if ("".equals(path)) {
            return dir;
        }
        return (dir + "/" + path).replace("//", "/");
    }

    private void requireParent(String path) throws IOException {
        String parent = this.dirname(path);
        if (!this.files.containsKey(parent) || this.files.get(parent) != DIRECTORY) {
            throw new IOException(parent + " is not a directory");
        }
    }

    public void mkdir(String path) throws IOException {
        path = this.canonicalPath(path);
        this.requireParent(path);
        if (this.files.get(path) != DIRECTORY) {
            throw new IOException(path + " is a file");
        }
        this.files.put(path, null);
    }

    public CharProducer read(String path) throws IOException {
        Content content = this.files.get(path = this.canonicalPath(path));
        if (content != DIRECTORY) {
            return CharProducer.Factory.fromString((CharSequence)content.getText(), this.toInputSource(path));
        }
        throw new FileNotFoundException(path);
    }

    public InputSource toInputSource(String path) {
        return new InputSource(ZipFileSystem.fileUriWithPath(path));
    }

    public Writer write(String path) throws IOException {
        path = this.canonicalPath(path);
        this.requireParent(path);
        if (this.files.containsKey(path) && this.files.get(path) == DIRECTORY) {
            throw new IOException(path + " is a directory");
        }
        this.files.put(path, new Content("", null));
        final String outPath = path;
        return new StringWriter(){

            public void close() throws IOException {
                super.close();
                ZipFileSystem.this.files.put(outPath, new Content(this.toString(), null));
            }
        };
    }

    public OutputStream writeBytes(String path) throws IOException {
        path = this.canonicalPath(path);
        this.requireParent(path);
        if (this.files.containsKey(path) && this.files.get(path) == DIRECTORY) {
            throw new IOException(path + " is a directory");
        }
        this.files.put(path, new Content("", null));
        final String outPath = path;
        return new ByteArrayOutputStream(){

            public void close() throws IOException {
                super.close();
                ZipFileSystem.this.files.put(outPath, new Content(this.toByteArray(), null));
            }
        };
    }

    public Job toZip() throws IOException {
        ByteArrayOutputStream zippedBytes = new ByteArrayOutputStream();
        ZipOutputStream zipOut = new ZipOutputStream(zippedBytes);
        for (Map.Entry<String, Content> file : this.files.entrySet()) {
            ZipEntry ze;
            String path = file.getKey();
            Content content = file.getValue();
            if (content == DIRECTORY) {
                if ("/".equals(path)) continue;
                ze = new ZipEntry(path + "/");
                zipOut.putNextEntry(ze);
                continue;
            }
            ze = new ZipEntry(path);
            ze.setSize(content.byteLength());
            zipOut.putNextEntry(ze);
            content.toOutputStream(zipOut);
        }
        zipOut.close();
        return Job.zip(zippedBytes.toByteArray());
    }
}

