/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

final class Normalizer {
    private static final Method IS_NORMALIZED;
    private static final Object NORMAL_FORM_C;

    Normalizer() {
    }

    public static boolean isNormalized(CharSequence s) {
        if (IS_NORMALIZED != null) {
            try {
                return (Boolean)IS_NORMALIZED.invoke(null, s, NORMAL_FORM_C);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            catch (InvocationTargetException ex) {
                Throwable th = ex.getTargetException();
                if (th instanceof RuntimeException) {
                    throw (RuntimeException)th;
                }
                throw (Error)th;
            }
        }
        int i = s.length();
        while (--i >= 0) {
            char ch = s.charAt(i);
            if (ch < '\u0100') continue;
            return false;
        }
        return true;
    }

    static {
        Method isNormalized = null;
        Object normalFormC = null;
        try {
            Class<?> normalizer = Class.forName("java.text.Normalizer");
            Class<?> normalizerForm = Class.forName("java.text.Normalizer$Form");
            isNormalized = normalizer.getMethod("isNormalized", CharSequence.class, normalizerForm);
            normalFormC = normalizerForm.getField("NFC").get(null);
        }
        catch (ClassNotFoundException ex) {
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
        catch (NoSuchFieldException ex) {
            throw new RuntimeException(ex);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException(ex);
        }
        IS_NORMALIZED = isNormalized;
        NORMAL_FORM_C = normalFormC;
    }
}

