/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.html;

import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.HtmlTokenType;
import com.google.caja.lexer.Token;
import com.google.caja.parser.html.AttrStub;
import com.google.caja.parser.html.Html5ElementStack;
import com.google.caja.parser.html.IllegalDocumentStateException;
import com.google.caja.parser.html.Namespaces;
import com.google.caja.parser.html.XmlElementStack;
import com.google.caja.reporting.MessageQueue;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface OpenElementStack {
    public Document getDocument();

    public DocumentFragment getRootElement();

    public void processTag(Token<HtmlTokenType> var1, Token<HtmlTokenType> var2, List<AttrStub> var3) throws IllegalDocumentStateException;

    public void processText(Token<HtmlTokenType> var1);

    public void processComment(Token<HtmlTokenType> var1);

    public void open(boolean var1);

    public void finish(FilePosition var1) throws IllegalDocumentStateException;

    public boolean needsNamespaceFixup();

    public static final class Factory {
        public static OpenElementStack createHtml5ElementStack(Document doc, boolean needsDebugData, MessageQueue mq) {
            return new Html5ElementStack(doc, needsDebugData, mq);
        }

        public static OpenElementStack createXmlElementStack(Document doc, boolean needsDebugData, Namespaces ns, MessageQueue mq) {
            return new XmlElementStack(doc, ns, needsDebugData, mq);
        }

        private Factory() {
        }
    }
}

