/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.quasiliteral;

import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.JsLexer;
import com.google.caja.lexer.JsTokenQueue;
import com.google.caja.lexer.ParseException;
import com.google.caja.lexer.Token;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.ParserBase;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.DirectivePrologue;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.ExpressionStmt;
import com.google.caja.parser.js.FormalParam;
import com.google.caja.parser.js.FunctionDeclaration;
import com.google.caja.parser.js.Identifier;
import com.google.caja.parser.js.ObjectConstructor;
import com.google.caja.parser.js.Parser;
import com.google.caja.parser.js.Reference;
import com.google.caja.parser.js.Statement;
import com.google.caja.parser.js.StringLiteral;
import com.google.caja.parser.js.SyntheticNodes;
import com.google.caja.parser.quasiliteral.DirectivePrologueQuasiNode;
import com.google.caja.parser.quasiliteral.MultipleNonemptyQuasiHole;
import com.google.caja.parser.quasiliteral.MultipleQuasiHole;
import com.google.caja.parser.quasiliteral.ObjectConstructorHole;
import com.google.caja.parser.quasiliteral.QuasiNode;
import com.google.caja.parser.quasiliteral.Rule;
import com.google.caja.parser.quasiliteral.SimpleQuasiNode;
import com.google.caja.parser.quasiliteral.SingleOptionalIdentifierQuasiNode;
import com.google.caja.parser.quasiliteral.SingleOptionalQuasiHole;
import com.google.caja.parser.quasiliteral.SingleQuasiHole;
import com.google.caja.parser.quasiliteral.StringLiteralQuasiNode;
import com.google.caja.parser.quasiliteral.SyntheticQuasiNode;
import com.google.caja.parser.quasiliteral.TrailingUnderscoresHole;
import com.google.caja.reporting.DevNullMessageQueue;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuasiBuilder {
    private static final Map<String, QuasiNode> patternCache = new HashMap<String, QuasiNode>();

    public static boolean match(String patternText, ParseTreeNode specimen) {
        return QuasiBuilder.match(patternText, specimen, Rule.makeBindings());
    }

    public static boolean match(String patternText, ParseTreeNode specimen, Map<String, ParseTreeNode> bindings) {
        Map<String, ParseTreeNode> tempBindings = QuasiBuilder.getPatternNode(patternText).match(specimen);
        if (tempBindings != null) {
            bindings.putAll(tempBindings);
            return true;
        }
        return false;
    }

    public static ParseTreeNode subst(String patternText, Map<String, ParseTreeNode> bindings) {
        return QuasiBuilder.getPatternNode(patternText).substitute(bindings);
    }

    public static ParseTreeNode substV(String patternText, Object ... args) {
        if (args.length % 2 != 0) {
            throw new RuntimeException("Wrong # of args for subst()");
        }
        Map<String, ParseTreeNode> bindings = Rule.makeBindings();
        int i = 0;
        while (i < args.length) {
            bindings.put((String)args[i++], (ParseTreeNode)args[i++]);
        }
        ParseTreeNode result = QuasiBuilder.subst(patternText, bindings);
        if (result == null) {
            throw new NullPointerException("'" + patternText + "' > " + bindings.keySet());
        }
        return result;
    }

    public static QuasiNode parseQuasiNode(InputSource inputSource, String pattern) throws ParseException {
        Block topLevelBlock = (Block)QuasiBuilder.parse(inputSource, pattern);
        ParseTreeNode topLevelNode = topLevelBlock;
        if (topLevelNode.children().size() == 1) {
            topLevelNode = topLevelNode.children().get(0);
        }
        if (topLevelNode instanceof ExpressionStmt) {
            topLevelNode = topLevelNode.children().get(0);
        }
        if (topLevelNode instanceof FunctionDeclaration) {
            topLevelNode = ((FunctionDeclaration)topLevelNode).getInitializer();
        }
        return QuasiBuilder.build(topLevelNode);
    }

    public static QuasiNode parseQuasiNode(String pattern) throws ParseException {
        return QuasiBuilder.parseQuasiNode(FilePosition.UNKNOWN.source(), pattern);
    }

    private static QuasiNode getPatternNode(String patternText) {
        if (!patternCache.containsKey(patternText)) {
            try {
                patternCache.put(patternText, QuasiBuilder.parseQuasiNode(patternText));
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
        return patternCache.get(patternText);
    }

    private static QuasiNode build(ParseTreeNode n) {
        String bindingName;
        StringLiteral lit;
        String value;
        String name;
        if (n instanceof ExpressionStmt && ((ExpressionStmt)n).getExpression() instanceof Reference && (name = ((Reference)n.children().get(0)).getIdentifierName()).startsWith("@") && !name.endsWith("_")) {
            return QuasiBuilder.buildMatchNode(Statement.class, name);
        }
        if (n instanceof Reference && (name = ((Reference)n).getIdentifierName()).startsWith("@") && !name.endsWith("_")) {
            return QuasiBuilder.buildMatchNode(Expression.class, name);
        }
        if (n instanceof FormalParam && (name = ((FormalParam)n).getIdentifierName()).startsWith("@")) {
            return QuasiBuilder.buildMatchNode(FormalParam.class, name);
        }
        if (n instanceof Identifier && (name = ((Identifier)n).getName()) != null && name.startsWith("@")) {
            boolean isOptional = name.endsWith("?");
            if (isOptional) {
                name = name.substring(0, name.length() - 1);
            }
            QuasiNode qn = name.endsWith("_") ? QuasiBuilder.buildTrailingUnderscoreMatchNode(name) : QuasiBuilder.buildMatchNode(Identifier.class, name);
            if (isOptional) {
                qn = new SingleOptionalIdentifierQuasiNode(qn);
            }
            return qn;
        }
        if (n instanceof ObjectConstructor && n.children().size() == 2 && n.children().get(0) instanceof StringLiteral && n.children().get(1) instanceof Reference) {
            String key = ((StringLiteral)n.children().get(0)).getUnquotedValue();
            String val = ((Reference)n.children().get(1)).getIdentifierName();
            if (key.startsWith("@") && key.endsWith("*") && val.startsWith("@") && val.endsWith("*")) {
                return QuasiBuilder.buildObjectConstructorMatchNode(key, val);
            }
        }
        if (n instanceof DirectivePrologue) {
            return QuasiBuilder.buildDirectivePrologueMatchNode(((DirectivePrologue)n).getDirectives());
        }
        if (n instanceof StringLiteral && (value = (lit = (StringLiteral)n).getUnquotedValue()).startsWith("@") && ParserBase.isJavascriptIdentifier(bindingName = value.substring(1))) {
            return new StringLiteralQuasiNode(bindingName);
        }
        return QuasiBuilder.buildSimpleNode(n);
    }

    private static QuasiNode buildSimpleNode(ParseTreeNode n) {
        boolean isSynthetic = false;
        if (QuasiBuilder.hasSyntheticAnnotation(n)) {
            isSynthetic = true;
        } else if (n instanceof Identifier) {
            Identifier ident = (Identifier)n;
            isSynthetic = ident.getName() != null && ident.getName().endsWith("__");
        } else if (n instanceof Reference) {
            Reference ref = (Reference)n;
            isSynthetic = ref.getIdentifierName().endsWith("__");
        }
        if (isSynthetic) {
            return new SyntheticQuasiNode(n.getClass(), n.getValue(), QuasiBuilder.buildChildrenOf(n));
        }
        return new SimpleQuasiNode(n.getClass(), n.getValue(), QuasiBuilder.buildChildrenOf(n));
    }

    private static boolean hasSyntheticAnnotation(ParseTreeNode n) {
        for (Token<?> comment : n.getComments()) {
            if (comment.text.indexOf("@synthetic") < 0) continue;
            return SyntheticNodes.isSynthesizable(n);
        }
        return false;
    }

    private static QuasiNode buildMatchNode(Class<? extends ParseTreeNode> matchedClass, String quasiString) {
        assert (quasiString.startsWith("@"));
        if (quasiString.endsWith("*")) {
            return new MultipleQuasiHole(matchedClass, quasiString.substring(1, quasiString.length() - 1));
        }
        if (quasiString.endsWith("+")) {
            return new MultipleNonemptyQuasiHole(matchedClass, quasiString.substring(1, quasiString.length() - 1));
        }
        if (quasiString.endsWith("?")) {
            return new SingleOptionalQuasiHole(matchedClass, quasiString.substring(1, quasiString.length() - 1));
        }
        return new SingleQuasiHole(matchedClass, quasiString.substring(1, quasiString.length()));
    }

    private static QuasiNode buildTrailingUnderscoreMatchNode(String quasiString) {
        assert (quasiString.startsWith("@"));
        assert (quasiString.endsWith("_"));
        quasiString = quasiString.substring(1, quasiString.length());
        int numberOfUnderscores = 0;
        while (quasiString.endsWith("_")) {
            quasiString = quasiString.substring(0, quasiString.length() - 1);
            ++numberOfUnderscores;
        }
        return new TrailingUnderscoresHole(quasiString, numberOfUnderscores);
    }

    private static QuasiNode buildObjectConstructorMatchNode(String keyExpr, String valueExpr) {
        keyExpr = keyExpr.substring(1, keyExpr.length() - 1);
        valueExpr = valueExpr.substring(1, valueExpr.length() - 1);
        return new ObjectConstructorHole(keyExpr, valueExpr);
    }

    private static QuasiNode buildDirectivePrologueMatchNode(Set<String> subsetNames) {
        return new DirectivePrologueQuasiNode(subsetNames);
    }

    private static QuasiNode[] buildChildrenOf(ParseTreeNode n) {
        ArrayList<QuasiNode> children = new ArrayList<QuasiNode>();
        for (ParseTreeNode parseTreeNode : n.children()) {
            children.add(QuasiBuilder.build(parseTreeNode));
        }
        return children.toArray(new QuasiNode[children.size()]);
    }

    private static ParseTreeNode parse(InputSource inputSource, String sourceText) throws ParseException {
        Parser parser = new Parser(new JsTokenQueue(new JsLexer(CharProducer.Factory.create(new StringReader(sourceText), inputSource), true), inputSource), DevNullMessageQueue.singleton(), true);
        Block topLevelStatement = parser.parse();
        parser.getTokenQueue().expectEmpty();
        return topLevelStatement;
    }
}

