/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin;

import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.TokenConsumer;
import com.google.caja.parser.AncestorChain;
import com.google.caja.parser.Visitor;
import com.google.caja.parser.css.CssTree;
import com.google.caja.parser.js.ArrayConstructor;
import com.google.caja.parser.js.StringLiteral;
import com.google.caja.plugin.PluginMeta;
import com.google.caja.render.Concatenator;
import com.google.caja.render.CssPrettyPrinter;
import com.google.caja.reporting.RenderContext;
import com.google.caja.util.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class CssRuleRewriter {
    private static final String GADGET_ID_PLACEHOLDER = "___GADGET___";
    private final String gadgetNameSuffix;

    public CssRuleRewriter(PluginMeta meta) {
        String idSuffix = meta.getIdClass();
        this.gadgetNameSuffix = idSuffix != null ? idSuffix : GADGET_ID_PLACEHOLDER;
    }

    public void rewriteCss(CssTree.StyleSheet ss) {
        this.rewriteIds(ss);
        this.restrictRulesToSubtreeWithGadgetClass(ss);
    }

    private void rewriteIds(CssTree.StyleSheet ss) {
        ss.acceptPreOrder(new Visitor(){

            @Override
            public boolean visit(AncestorChain<?> ancestors) {
                Object node = ancestors.node;
                if (!(node instanceof CssTree.SimpleSelector)) {
                    return true;
                }
                CssTree.SimpleSelector ss = (CssTree.SimpleSelector)node;
                List<? extends CssTree> children = ss.children();
                int n = children.size();
                for (int i = 0; i < n; ++i) {
                    CssTree child = children.get(i);
                    if (!(child instanceof CssTree.IdLiteral)) continue;
                    CssTree.IdLiteral idLit = (CssTree.IdLiteral)child;
                    idLit.setValue("#" + idLit.getValue().substring(1) + "-" + CssRuleRewriter.this.gadgetNameSuffix);
                }
                return true;
            }
        }, null);
    }

    private void restrictRulesToSubtreeWithGadgetClass(CssTree.StyleSheet ss) {
        ss.acceptPreOrder(new Visitor(){

            @Override
            public boolean visit(AncestorChain<?> ancestors) {
                Object node = ancestors.node;
                if (!(node instanceof CssTree.Selector)) {
                    return true;
                }
                CssTree.Selector sel = (CssTree.Selector)node;
                CssTree.SimpleSelector baseSelector = (CssTree.SimpleSelector)sel.children().get(0);
                boolean baseIsDescendant = true;
                if (CssRuleRewriter.selectorMatchesElement(baseSelector, "body")) {
                    if (sel.children().size() > 2 && CssRuleRewriter.isDescendant(sel.children().get(1))) {
                        baseSelector = (CssTree.SimpleSelector)sel.children().get(2);
                    } else {
                        CssTree.IdentLiteral elName = (CssTree.IdentLiteral)baseSelector.children().get(0);
                        baseSelector.replaceChild(new CssTree.ClassLiteral(elName.getFilePosition(), ".vdoc-body___"), elName);
                        baseIsDescendant = false;
                    }
                }
                FilePosition pos = FilePosition.startOf(baseSelector.getFilePosition());
                CssTree.ClassLiteral restrictClass = new CssTree.ClassLiteral(pos, "." + CssRuleRewriter.this.gadgetNameSuffix);
                if (baseIsDescendant) {
                    CssTree.Combination op = new CssTree.Combination(pos, CssTree.Combinator.DESCENDANT);
                    CssTree.SimpleSelector restrictSel = new CssTree.SimpleSelector(pos, Collections.singletonList(restrictClass));
                    sel.createMutation().insertBefore(op, baseSelector).insertBefore(restrictSel, op).execute();
                } else {
                    baseSelector.appendChild(restrictClass);
                }
                return false;
            }
        }, null);
    }

    public static ArrayConstructor cssToJs(CssTree.StyleSheet ss) {
        final ArrayList cssParts = new ArrayList();
        TokenConsumer cssCompiler = new TokenConsumer(){
            final StringBuilder sb = new StringBuilder();
            final CssPrettyPrinter pp = new CssPrettyPrinter(new Concatenator(this.sb));

            public void mark(FilePosition p) {
                this.pp.mark(p);
            }

            public void consume(String s) {
                this.pp.consume(s);
                if (s.endsWith(CssRuleRewriter.GADGET_ID_PLACEHOLDER)) {
                    this.flush();
                }
            }

            public void noMoreTokens() {
                this.pp.noMoreTokens();
                this.flush();
            }

            private void flush() {
                String content = this.sb.toString();
                if (content.endsWith(CssRuleRewriter.GADGET_ID_PLACEHOLDER)) {
                    content = content.substring(0, content.length() - CssRuleRewriter.GADGET_ID_PLACEHOLDER.length());
                }
                cssParts.add(StringLiteral.valueOf(FilePosition.UNKNOWN, content));
                this.sb.setLength(0);
            }
        };
        ss.render(new RenderContext(cssCompiler));
        cssCompiler.noMoreTokens();
        return new ArrayConstructor(ss.getFilePosition(), cssParts);
    }

    private static boolean selectorMatchesElement(CssTree.SimpleSelector t, String elementName) {
        return Strings.equalsIgnoreCase(elementName, t.getElementName());
    }

    private static boolean isDescendant(CssTree t) {
        return t instanceof CssTree.Combination && CssTree.Combinator.DESCENDANT == ((CssTree.Combination)t).getCombinator();
    }
}

