/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin.templates;

import com.google.caja.plugin.templates.LocalizedHtml;
import java.awt.ComponentOrientation;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IhtmlL10NContext {
    private final Locale locale;
    private final Map<String, LocalizedHtml> messages;

    public IhtmlL10NContext(Locale locale, Map<String, LocalizedHtml> messages) {
        this.locale = locale;
        this.messages = new LinkedHashMap<String, LocalizedHtml>(messages);
    }

    public LocalizedHtml getMessageByName(String messageName) {
        return this.messages.get(messageName);
    }

    public boolean isLeftToRight() {
        return ComponentOrientation.getOrientation(this.locale).isLeftToRight();
    }

    public Iterable<String> getMessageNames() {
        return Collections.unmodifiableCollection(this.messages.keySet());
    }

    public Locale getLocale() {
        return this.locale;
    }
}

