/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin.templates;

import com.google.caja.lexer.FilePosition;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.Operation;
import com.google.caja.parser.js.Operator;
import com.google.caja.parser.js.StringLiteral;
import com.google.caja.plugin.templates.Emitter;
import com.google.caja.plugin.templates.Part;
import com.google.caja.plugin.templates.SideEffectPart;
import com.google.caja.plugin.templates.StringPart;
import java.util.ArrayList;
import java.util.List;

public final class JsConcatenator {
    private final List<Part> parts = new ArrayList<Part>();

    public void append(FilePosition pos, String s) {
        this.append(StringLiteral.valueOf(pos, s));
    }

    public void append(Expression e) {
        List<? extends Expression> operands;
        StringLiteral sl = Emitter.asStringLiteral(e);
        if (sl != null && sl.getUnquotedValue().length() == 0) {
            return;
        }
        if (Emitter.is(e, Operator.ADDITION) && (Emitter.isStringy((operands = ((Operation)e).children()).get(0), false) || Emitter.isStringy(operands.get(1), false))) {
            this.append(operands.get(0));
            this.append(operands.get(1));
            return;
        }
        this.parts.add(new StringPart(sl != null ? sl : e));
    }

    public void forSideEffect(Expression e) {
        if ((e = e.simplifyForSideEffect()) != null) {
            this.parts.add(new SideEffectPart(e, true));
        }
    }

    public Expression toExpression(boolean mustBeString) {
        return new Emitter(new ArrayList<Part>(this.parts)).toExpression(mustBeString);
    }
}

