/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.protocol.conversion.xstream;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.shindig.protocol.conversion.xstream.NamespaceSet;
import org.apache.shindig.protocol.conversion.xstream.WriterStack;

public class ThreadSafeWriterStack
implements WriterStack {
    private ThreadLocal<List<Object[]>> stackHolder = new ThreadLocal<List<Object[]>>(){

        @Override
        protected List<Object[]> initialValue() {
            return Lists.newArrayList();
        }
    };

    public void push(String name, NamespaceSet namespaceSet) {
        this.stackHolder.get().add(new Object[]{name, namespaceSet});
    }

    public String pop() {
        List<Object[]> stack = this.stackHolder.get();
        if (stack.isEmpty()) {
            return null;
        }
        Object[] o = stack.remove(stack.size() - 1);
        if (o != null && o.length > 0) {
            return (String)o[0];
        }
        return null;
    }

    public String peek() {
        return (String)this.peek(0);
    }

    public NamespaceSet peekNamespace() {
        return (NamespaceSet)this.peek(1);
    }

    public Object peek(int i) {
        List<Object[]> stack = this.stackHolder.get();
        if (stack.isEmpty()) {
            return null;
        }
        Object[] o = stack.get(stack.size() - 1);
        if (o != null && o.length > i) {
            return o[i];
        }
        return null;
    }

    public void reset() {
        this.stackHolder.get().clear();
    }

    public int size() {
        List<Object[]> s = this.stackHolder.get();
        if (s == null) {
            return 0;
        }
        return s.size();
    }
}

