/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.opensocial.helper;

import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;
import org.nuxeo.runtime.api.Framework;

public class OpenSocialGadgetHelper {
    public static final String HTTP = "http://";
    public static final String HTTP_SEPARATOR = ":";

    private OpenSocialGadgetHelper() {
    }

    public static String getGadgetsBaseUrl(boolean relativeUrl) {
        return OpenSocialGadgetHelper.getGadgetsBaseUrl(relativeUrl, true);
    }

    public static String getGadgetsBaseUrl(boolean relativeUrl, boolean addContextPath) {
        boolean gadgetsEmbeddedServer = Boolean.valueOf(Framework.getProperty((String)"opensocial.gadgets.embeddedServer", (String)"true"));
        StringBuilder sb = new StringBuilder();
        if (gadgetsEmbeddedServer) {
            if (!relativeUrl) {
                sb.append(Framework.getProperty((String)"nuxeo.loopback.url"));
            } else {
                sb.append(VirtualHostHelper.getContextPathProperty());
            }
        } else {
            sb.append(HTTP);
            sb.append(Framework.getProperty((String)"opensocial.gadgets.host"));
            sb.append(HTTP_SEPARATOR);
            sb.append(Framework.getProperty((String)"opensocial.gadgets.port"));
            if (addContextPath) {
                sb.append(VirtualHostHelper.getContextPathProperty());
            }
        }
        return sb.toString();
    }

    public static String computeGadgetDefUrlBeforeSave(String gadgetDef) {
        String urlToCheck = OpenSocialGadgetHelper.getGadgetsBaseUrl(false);
        if (gadgetDef.contains(urlToCheck)) {
            gadgetDef = gadgetDef.split(urlToCheck)[1];
        }
        return gadgetDef;
    }

    public static String computeGadgetDefUrlAfterLoad(String gadgetDefUrl) {
        if (!gadgetDefUrl.contains("://")) {
            gadgetDefUrl = OpenSocialGadgetHelper.getGadgetsBaseUrl(false) + gadgetDefUrl;
        }
        return gadgetDefUrl;
    }
}

