/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.js;

import com.google.caja.parser.js.Associativity;
import com.google.caja.parser.js.OperatorCategory;
import com.google.caja.parser.js.OperatorType;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Operator {
    SQUARE_BRACKET(OperatorType.BRACKET, OperatorCategory.SPECIAL, 1, Associativity.LEFT, "[]"),
    MEMBER_ACCESS(OperatorType.INFIX, OperatorCategory.SPECIAL, 1, Associativity.LEFT, "."),
    CONSTRUCTOR(OperatorType.PREFIX, OperatorCategory.SPECIAL, 1, Associativity.RIGHT, "new"),
    FUNCTION_CALL(OperatorType.BRACKET, OperatorCategory.SPECIAL, 2, Associativity.LEFT, "()"),
    POST_INCREMENT(OperatorType.POSTFIX, OperatorCategory.ASSIGNMENT, 3, null, "++"),
    POST_DECREMENT(OperatorType.POSTFIX, OperatorCategory.ASSIGNMENT, 3, null, "--"),
    DELETE(OperatorType.PREFIX, OperatorCategory.SPECIAL, 4, Associativity.RIGHT, "delete"),
    VOID(OperatorType.PREFIX, OperatorCategory.SPECIAL, 4, Associativity.RIGHT, "void"),
    TYPEOF(OperatorType.PREFIX, OperatorCategory.SPECIAL, 4, Associativity.RIGHT, "typeof"),
    IN(OperatorType.INFIX, OperatorCategory.SPECIAL, 8, Associativity.LEFT, "in"),
    PRE_INCREMENT(OperatorType.PREFIX, OperatorCategory.ASSIGNMENT, 4, Associativity.RIGHT, "++"),
    PRE_DECREMENT(OperatorType.PREFIX, OperatorCategory.ASSIGNMENT, 4, Associativity.RIGHT, "--"),
    TO_NUMBER(OperatorType.PREFIX, OperatorCategory.SIMPLE, 4, Associativity.RIGHT, "+"),
    NEGATION(OperatorType.PREFIX, OperatorCategory.SIMPLE, 4, Associativity.RIGHT, "-"),
    INVERSE(OperatorType.PREFIX, OperatorCategory.SIMPLE, 4, Associativity.RIGHT, "~"),
    NOT(OperatorType.PREFIX, OperatorCategory.SIMPLE, 4, Associativity.RIGHT, "!"),
    MULTIPLICATION(OperatorType.INFIX, OperatorCategory.SIMPLE, 5, Associativity.LEFT, "*"),
    DIVISION(OperatorType.INFIX, OperatorCategory.SIMPLE, 5, Associativity.LEFT, "/"),
    MODULUS(OperatorType.INFIX, OperatorCategory.SIMPLE, 5, Associativity.LEFT, "%"),
    ADDITION(OperatorType.INFIX, OperatorCategory.SIMPLE, 6, Associativity.LEFT, "+"),
    SUBTRACTION(OperatorType.INFIX, OperatorCategory.SIMPLE, 6, Associativity.LEFT, "-"),
    LSHIFT(OperatorType.INFIX, OperatorCategory.SIMPLE, 7, Associativity.LEFT, "<<"),
    RSHIFT(OperatorType.INFIX, OperatorCategory.SIMPLE, 7, Associativity.LEFT, ">>"),
    RUSHIFT(OperatorType.INFIX, OperatorCategory.SIMPLE, 7, Associativity.LEFT, ">>>"),
    LESS_THAN(OperatorType.INFIX, OperatorCategory.SIMPLE, 8, Associativity.LEFT, "<"),
    GREATER_THAN(OperatorType.INFIX, OperatorCategory.SIMPLE, 8, Associativity.LEFT, ">"),
    LESS_EQUALS(OperatorType.INFIX, OperatorCategory.SIMPLE, 8, Associativity.LEFT, "<="),
    GREATER_EQUALS(OperatorType.INFIX, OperatorCategory.SIMPLE, 8, Associativity.LEFT, ">="),
    INSTANCE_OF(OperatorType.INFIX, OperatorCategory.SIMPLE, 8, Associativity.LEFT, "instanceof"),
    EQUAL(OperatorType.INFIX, OperatorCategory.SIMPLE, 9, Associativity.LEFT, "=="),
    NOT_EQUAL(OperatorType.INFIX, OperatorCategory.SIMPLE, 9, Associativity.LEFT, "!="),
    STRICTLY_EQUAL(OperatorType.INFIX, OperatorCategory.SIMPLE, 9, Associativity.LEFT, "==="),
    STRICTLY_NOT_EQUAL(OperatorType.INFIX, OperatorCategory.SIMPLE, 9, Associativity.LEFT, "!=="),
    BITWISE_AND(OperatorType.INFIX, OperatorCategory.SIMPLE, 10, Associativity.LEFT, "&"),
    BITWISE_XOR(OperatorType.INFIX, OperatorCategory.SIMPLE, 11, Associativity.LEFT, "^"),
    BITWISE_OR(OperatorType.INFIX, OperatorCategory.SIMPLE, 12, Associativity.LEFT, "|"),
    LOGICAL_AND(OperatorType.INFIX, OperatorCategory.CONTROL, 13, Associativity.LEFT, "&&"),
    LOGICAL_OR(OperatorType.INFIX, OperatorCategory.CONTROL, 14, Associativity.LEFT, "||"),
    TERNARY(OperatorType.TERNARY, OperatorCategory.CONTROL, 15, Associativity.RIGHT, "?:"),
    ASSIGN(OperatorType.INFIX, OperatorCategory.ASSIGNMENT, 16, Associativity.RIGHT, "="),
    ASSIGN_MUL(OperatorType.INFIX, OperatorCategory.ASSIGNMENT, 16, Associativity.RIGHT, "*=", MULTIPLICATION),
    ASSIGN_DIV(OperatorType.INFIX, OperatorCategory.ASSIGNMENT, 16, Associativity.RIGHT, "/=", DIVISION),
    ASSIGN_MOD(OperatorType.INFIX, OperatorCategory.ASSIGNMENT, 16, Associativity.RIGHT, "%=", MODULUS),
    ASSIGN_SUM(OperatorType.INFIX, OperatorCategory.ASSIGNMENT, 16, Associativity.RIGHT, "+=", ADDITION),
    ASSIGN_SUB(OperatorType.INFIX, OperatorCategory.ASSIGNMENT, 16, Associativity.RIGHT, "-=", SUBTRACTION),
    ASSIGN_LSH(OperatorType.INFIX, OperatorCategory.ASSIGNMENT, 16, Associativity.RIGHT, "<<=", LSHIFT),
    ASSIGN_RSH(OperatorType.INFIX, OperatorCategory.ASSIGNMENT, 16, Associativity.RIGHT, ">>=", RSHIFT),
    ASSIGN_USH(OperatorType.INFIX, OperatorCategory.ASSIGNMENT, 16, Associativity.RIGHT, ">>>=", RUSHIFT),
    ASSIGN_AND(OperatorType.INFIX, OperatorCategory.ASSIGNMENT, 16, Associativity.RIGHT, "&=", BITWISE_AND),
    ASSIGN_XOR(OperatorType.INFIX, OperatorCategory.ASSIGNMENT, 16, Associativity.RIGHT, "^=", BITWISE_XOR),
    ASSIGN_OR(OperatorType.INFIX, OperatorCategory.ASSIGNMENT, 16, Associativity.RIGHT, "|=", BITWISE_OR),
    COMMA(OperatorType.INFIX, OperatorCategory.SPECIAL, 17, Associativity.LEFT, ",");

    private OperatorType type;
    private OperatorCategory category;
    private int precedence;
    private Associativity associativity;
    private String symbol;
    private Operator assignmentDelegate;
    private static Map<OperatorType, Map<String, Operator>> symbolsByType;

    private Operator(OperatorType type, OperatorCategory category, int precedence, Associativity assoc, String symbol) {
        this(type, category, precedence, assoc, symbol, null);
    }

    private Operator(OperatorType type, OperatorCategory category, int precedence, Associativity assoc, String symbol, Operator assignmentDelegate) {
        if (assignmentDelegate != null && assignmentDelegate.getType() != OperatorType.INFIX) {
            throw new IllegalArgumentException((Object)((Object)assignmentDelegate) + " cannot be used as an assignment delegate");
        }
        this.type = type;
        this.category = category;
        this.precedence = precedence;
        this.associativity = assoc;
        this.symbol = symbol;
        this.assignmentDelegate = assignmentDelegate;
    }

    public OperatorType getType() {
        return this.type;
    }

    public OperatorCategory getCategory() {
        return this.category;
    }

    public int getPrecedence() {
        return this.precedence;
    }

    public Associativity getAssociativity() {
        return this.associativity;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public String getClosingSymbol() {
        switch (this.type) {
            default: {
                return null;
            }
            case BRACKET: 
            case TERNARY: 
        }
        return this.symbol.substring(this.symbol.length() / 2);
    }

    public String getOpeningSymbol() {
        switch (this.type) {
            default: {
                return this.symbol;
            }
            case BRACKET: 
            case TERNARY: 
        }
        return this.symbol.substring(0, this.symbol.length() / 2);
    }

    public Operator getAssignmentDelegate() {
        return this.assignmentDelegate;
    }

    public static Operator lookupOperation(String symbol, OperatorType type) {
        Initializer.initSymbols();
        return symbolsByType.get((Object)type).get(symbol);
    }

    static {
        for (Operator op : Operator.values()) {
            Operator assignmentDelegate = op.assignmentDelegate;
            if (assignmentDelegate != null && (assignmentDelegate == ASSIGN || assignmentDelegate.assignmentDelegate != null)) {
                throw new AssertionError((Object)((Object)((Object)op) + " cannot delegate assignment to an assignment operator: " + (Object)((Object)assignmentDelegate)));
            }
        }
    }

    private static class Initializer {
        private Initializer() {
        }

        static void initSymbols() {
        }

        static {
            symbolsByType = new EnumMap(OperatorType.class);
            for (OperatorType operatorType : OperatorType.values()) {
                HashMap symbolMap = new HashMap();
                symbolsByType.put(operatorType, symbolMap);
            }
            for (Enum enum_ : Operator.values()) {
                if (null != ((Map)symbolsByType.get((Object)((Operator)enum_).getType())).put(((Operator)enum_).getOpeningSymbol(), enum_)) {
                    throw new AssertionError((Object)("Duplicate symbol " + ((Operator)enum_).getSymbol() + " for type " + (Object)((Object)((Operator)enum_).getType())));
                }
            }
        }
    }
}

