/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.quasiliteral;

import com.google.caja.parser.quasiliteral.Rewriter;
import com.google.caja.parser.quasiliteral.Rule;
import com.google.caja.parser.quasiliteral.RuleDescription;
import com.google.caja.parser.quasiliteral.RulesetDescription;
import java.io.IOException;
import java.io.Writer;

public abstract class RuleDoclet {
    protected Rewriter rewriter;

    public void setRewriter(Rewriter rewriter) {
        this.rewriter = rewriter;
    }

    public void initialize(Writer output) {
    }

    public void finish(Writer output) throws IOException {
    }

    public abstract String getDefaultExtension();

    public abstract void generateHeader(Writer var1, RulesetDescription var2) throws IOException;

    public abstract void generateFooter(Writer var1, RulesetDescription var2) throws IOException;

    public abstract void generateRuleDocumentation(Writer var1, RuleDescription var2) throws IOException;

    public void generateDocumentation(Writer output) throws IOException {
        try {
            RulesetDescription ruleSetDescription = this.rewriter.getClass().getAnnotation(RulesetDescription.class);
            this.initialize(output);
            this.generateHeader(output, ruleSetDescription);
            for (Rule rule : this.rewriter.getRules()) {
                RuleDescription anno = rule.getRuleDescription();
                if (anno == null) continue;
                this.generateRuleDocumentation(output, anno);
            }
            this.generateFooter(output, ruleSetDescription);
            this.finish(output);
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
            throw ex;
        }
    }
}

