/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.social.workspace.computedgroups;

import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.activity.ActivityHelper;
import org.nuxeo.ecm.platform.computedgroups.AbstractGroupComputer;
import org.nuxeo.ecm.platform.usermanager.NuxeoPrincipalImpl;
import org.nuxeo.ecm.social.relationship.service.RelationshipService;
import org.nuxeo.ecm.social.workspace.helper.SocialWorkspaceHelper;
import org.nuxeo.runtime.api.Framework;

public class SocialWorkspaceGroupComputer
extends AbstractGroupComputer {
    protected RelationshipService relationshipService;
    private static final Log log = LogFactory.getLog(SocialWorkspaceGroupComputer.class);

    public List<String> getGroupsForUser(NuxeoPrincipalImpl nuxeoPrincipal) {
        String user = ActivityHelper.createUserActivityObject((Principal)nuxeoPrincipal);
        ArrayList<String> groupsId = new ArrayList<String>();
        for (String swId : this.getRelationshipService().getTargetsOfKind(user, SocialWorkspaceHelper.buildRelationMemberKind())) {
            groupsId.add(SocialWorkspaceHelper.getSocialWorkspaceMembersGroupName(swId));
        }
        for (String swId : this.getRelationshipService().getTargetsOfKind(user, SocialWorkspaceHelper.buildRelationAdministratorKind())) {
            groupsId.add(SocialWorkspaceHelper.getSocialWorkspaceAdministratorsGroupName(swId));
        }
        return groupsId;
    }

    public List<String> getAllGroupIds() {
        return null;
    }

    public List<String> getGroupMembers(String groupName) {
        if (!SocialWorkspaceHelper.isValidSocialWorkspaceGroupName(groupName)) {
            return null;
        }
        return this.getRelationshipService().getTargetsOfKind(SocialWorkspaceHelper.getRelationDocActivityObjectFromGroupName(groupName), SocialWorkspaceHelper.buildRelationKindFromGroupName(groupName));
    }

    public List<String> getParentsGroupNames(String groupName) {
        return null;
    }

    public List<String> getSubGroupsNames(String groupName) {
        return null;
    }

    protected RelationshipService getRelationshipService() {
        if (this.relationshipService == null) {
            try {
                this.relationshipService = (RelationshipService)Framework.getService(RelationshipService.class);
            }
            catch (Exception e) {
                log.warn((Object)"Cannot retrieve RelationshipService Service");
                log.debug((Object)e, (Throwable)e);
            }
        }
        return this.relationshipService;
    }
}

