/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.image.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class PlainLogFormatter
extends Formatter {
    private static final String PADDER = "                                                                          ";
    private Date now = new Date();
    private DateFormat dateFormat = new SimpleDateFormat("HH:mm:ss.SSS");
    private String lineSeparator = "\n";

    private static String padded(String s, int width) {
        int i = s.length() - Math.abs(width);
        if (i < 0) {
            i = 0;
        }
        return width < 0 ? (s + PADDER).substring(0, -width) : (s + PADDER).substring(i, i + width);
    }

    public synchronized String format(LogRecord record) {
        StringBuffer sb = new StringBuffer();
        this.now.setTime(record.getMillis());
        sb.append(this.dateFormat.format(this.now));
        sb.append(" ");
        sb.append("[");
        sb.append(PlainLogFormatter.padded(Thread.currentThread().getName(), 18));
        sb.append("] ");
        sb.append(PlainLogFormatter.padded(record.getLevel().getName(), 7));
        sb.append(" ");
        String s = record.getSourceClassName();
        if (s == null) {
            s = record.getLoggerName();
            sb.append(PlainLogFormatter.padded(s, 32));
        } else {
            int j = s.lastIndexOf(46);
            if (j > 0) {
                s = s.substring(j + 1);
            }
            if ((j = s.lastIndexOf(36)) > 0) {
                s = s.substring(0, j);
            }
            sb.append(PlainLogFormatter.padded(s, -26));
        }
        sb.append(" - ");
        String message = this.formatMessage(record);
        sb.append(message);
        sb.append(this.lineSeparator);
        if (record.getThrown() != null) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                record.getThrown().printStackTrace(pw);
                pw.close();
                sb.append(sw.toString());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return sb.toString();
    }
}

